/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.beehive.netui.pageflow.FacesBackingBean;
import org.apache.beehive.netui.pageflow.GlobalApp;
import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.SharedFlowController;
import org.apache.beehive.netui.pageflow.internal.AnyBeanActionForm;
import org.apache.beehive.netui.pageflow.internal.FacesBackingBeanFactory;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.script.common.BundleMap;
import org.apache.beehive.netui.script.common.ContextFactory;
import org.apache.beehive.netui.script.el.NetUIUpdateVariableResolver;
import org.apache.beehive.netui.util.config.ConfigUtil;
import org.apache.beehive.netui.util.config.bean.BindingContexts;
import org.apache.beehive.netui.util.config.bean.ExpressionLanguages;
import org.apache.beehive.netui.util.config.bean.NetuiConfigDocument;
import org.apache.beehive.netui.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitObjectUtil {
    private static final Logger LOGGER = Logger.getInstance(ImplicitObjectUtil.class);
    private static final String PAGE_FLOW_IMPLICIT_OBJECT_KEY = "pageFlow";
    private static final String SHARED_FLOW_IMPLICIT_OBJECT_KEY = "sharedFlow";
    private static final String GLOBAL_APP_IMPLICIT_OBJECT_KEY = "globalApp";
    private static final String BUNDLE_IMPLICIT_OBJECT_KEY = "bundle";
    private static final String BACKING_IMPLICIT_OBJECT_KEY = "backing";
    private static final String PAGE_INPUT_IMPLICIT_OBJECT_KEY = "pageInput";
    private static final String ACTION_FORM_IMPLICIT_OBJECT_KEY = "actionForm";
    private static final String OUTPUT_FORM_BEAN_OBJECT_KEY = "outputFormBean";

    private ImplicitObjectUtil() {
    }

    public static final void loadActionForm(JspContext jspContext, Object form) {
        jspContext.setAttribute(ACTION_FORM_IMPLICIT_OBJECT_KEY, ImplicitObjectUtil.unwrapForm(form));
    }

    public static final void unloadActionForm(JspContext jspContext) {
        jspContext.removeAttribute(ACTION_FORM_IMPLICIT_OBJECT_KEY);
    }

    public static final void loadPageFlow(ServletRequest request, PageFlowController pageFlow, FacesBackingBean fbb) {
        Map map;
        if (pageFlow == null) {
            return;
        }
        request.setAttribute(PAGE_FLOW_IMPLICIT_OBJECT_KEY, (Object)pageFlow);
        if (fbb != null) {
            request.setAttribute(BACKING_IMPLICIT_OBJECT_KEY, (Object)fbb);
        }
        request.setAttribute(PAGE_INPUT_IMPLICIT_OBJECT_KEY, (Object)((map = InternalUtils.getPageInputMap(request)) != null ? map : Collections.EMPTY_MAP));
    }

    public static final void loadSharedFlow(ServletRequest request, Map<String, SharedFlowController> sharedFlows) {
        if (sharedFlows != null) {
            request.setAttribute(SHARED_FLOW_IMPLICIT_OBJECT_KEY, sharedFlows);
        }
    }

    public static final void loadGlobalApp(ServletRequest request, GlobalApp globalApp) {
        if (globalApp != null) {
            request.setAttribute(GLOBAL_APP_IMPLICIT_OBJECT_KEY, (Object)globalApp);
        }
    }

    public static final void loadBundleMap(ServletRequest servletRequest, BundleMap bundleMap) {
        servletRequest.setAttribute(BUNDLE_IMPLICIT_OBJECT_KEY, (Object)bundleMap);
    }

    public static final Object unwrapForm(Object form) {
        if (LOGGER.isDebugEnabled() && form instanceof AnyBeanActionForm) {
            LOGGER.debug((Object)("using form of type: " + ((AnyBeanActionForm)((Object)form) != null ? ((Object)((Object)((AnyBeanActionForm)((Object)form)))).getClass().getName() : "null")));
        }
        if (form instanceof AnyBeanActionForm) {
            return ((AnyBeanActionForm)((Object)form)).getBean();
        }
        return form;
    }

    public static final Map<String, SharedFlowController> getSharedFlow(ServletRequest request) {
        return (Map)request.getAttribute(SHARED_FLOW_IMPLICIT_OBJECT_KEY);
    }

    public static final PageFlowController getPageFlow(ServletRequest request, ServletResponse response) {
        assert (request instanceof HttpServletRequest);
        PageFlowController jpf = PageFlowUtils.getCurrentPageFlow((HttpServletRequest)request);
        if (jpf != null) {
            return jpf;
        }
        RuntimeException re = new RuntimeException("There is no current PageFlow for the expression.");
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error((Object)"", (Throwable)re);
        }
        throw re;
    }

    public static final GlobalApp getGlobalApp(ServletRequest request, ServletResponse response) {
        assert (request instanceof HttpServletRequest);
        GlobalApp ga = PageFlowUtils.getGlobalApp((HttpServletRequest)request);
        if (ga == null) {
            RuntimeException re = new RuntimeException("Can not create the globalApp binding context; the GlobalApp object is null.");
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"", (Throwable)re);
            }
            throw re;
        }
        return ga;
    }

    public static final Object getImplicitObject(Map factories, VariableResolver vr, String name) {
        assert (factories != null);
        ContextFactory factory = (ContextFactory)factories.get(name);
        if (factory == null) {
            String msg = "Could not resolve ContextFactory for binding context named \"" + name + "\"";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        return factory.getInstance(vr);
    }

    public static final VariableResolver getUpdateVariableResolver(ServletRequest request, ServletResponse response, boolean isHandlingPost) {
        Object form = ImplicitObjectUtil.unwrapForm(request.getAttribute("org.apache.struts.taglib.html.BEAN"));
        return new NetUIUpdateVariableResolver(form, request, response, isHandlingPost);
    }

    public static final VariableResolver getUpdateVariableResolver(Object form, ServletRequest request, ServletResponse response, boolean isHandlingPost) {
        Object realForm = ImplicitObjectUtil.unwrapForm(form);
        return new NetUIUpdateVariableResolver(realForm, request, response, isHandlingPost);
    }

    public static final VariableResolver getReadVariableResolver(PageContext pageContext) {
        assert (pageContext != null);
        return pageContext.getVariableResolver();
    }

    public static final Map initialize(String languageName) {
        NetuiConfigDocument.NetuiConfig netuiConfig = ConfigUtil.getConfig();
        if (netuiConfig == null) {
            return null;
        }
        ExpressionLanguages languages = netuiConfig.getExpressionLanguages();
        if (languages == null) {
            return null;
        }
        ExpressionLanguages.ExpressionLanguage[] langArray = languages.getExpressionLanguageArray();
        if (langArray == null) {
            return null;
        }
        ExpressionLanguages.ExpressionLanguage language = null;
        for (int i = 0; i < langArray.length; ++i) {
            if (!langArray[i].getName().equals(languageName)) continue;
            language = langArray[i];
        }
        if (language == null) {
            return null;
        }
        Map config = ImplicitObjectUtil.readFromConfig(language);
        if (config == null) {
            return null;
        }
        LinkedHashMap<String, ContextFactory> map = new LinkedHashMap<String, ContextFactory>();
        ContextFactory factory = null;
        for (String name : config.keySet()) {
            String className = (String)config.get(name);
            try {
                Class<?> type = Class.forName(className);
                factory = (ContextFactory)type.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn((Object)("Could not create a ContextFactory for type \"" + className + "\" because the ContextFactory implementation class could not be found."));
                continue;
            }
            catch (Exception ex) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn((Object)("Could not create a ContextFactory for type \"" + className + "\" because an error occurred creating the factory.  Cause: " + ex), (Throwable)ex);
                continue;
            }
            if (map.containsKey(name)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Overwriting a previously defined ContextFactory named \"" + name + "\" with a new ContextFactory of type \"" + className + "\""));
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Adding a ContextFactory named \"" + name + "\" with implementation \"" + className + "\""));
            }
            map.put(name, factory);
        }
        return map;
    }

    private static final Map readFromConfig(ExpressionLanguages.ExpressionLanguage language) {
        assert (language != null);
        BindingContexts contexts = language.getBindingContexts();
        if (contexts == null) {
            return null;
        }
        BindingContexts.BindingContext[] array = contexts.getBindingContextArray();
        if (array == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < array.length; ++i) {
            map.put(array[i].getName(), array[i].getFactoryClass());
        }
        return map;
    }

    public static void loadImplicitObjects(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, PageFlowController curJpf) {
        if (curJpf != null) {
            FacesBackingBean fbb = FacesBackingBeanFactory.getFacesBackingBeanForRequest(request, response, servletContext);
            ImplicitObjectUtil.loadPageFlow((ServletRequest)request, curJpf, fbb);
        }
        BundleMap bundleMap = new BundleMap(request, servletContext, null);
        ImplicitObjectUtil.loadBundleMap((ServletRequest)request, bundleMap);
    }

    public static final void loadOutputFormBean(ServletRequest request, Object bean) {
        if (bean != null) {
            request.setAttribute(OUTPUT_FORM_BEAN_OBJECT_KEY, bean);
        }
    }
}

