/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.common;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.beehive.netui.pageflow.PageFlowUtils;
import org.apache.beehive.netui.pageflow.internal.InternalUtils;
import org.apache.beehive.netui.script.common.AbstractScriptableMap;
import org.apache.beehive.netui.util.logging.Logger;

public class ScriptablePageInput
extends AbstractScriptableMap {
    private static final Logger _logger = Logger.getInstance(ScriptablePageInput.class);
    private HttpServletRequest _request = null;
    private Set _entrySet = null;

    public ScriptablePageInput(ServletRequest request) {
        assert (request instanceof HttpServletRequest);
        this._request = (HttpServletRequest)request;
    }

    public Object get(Object name) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("page input get: " + name));
        }
        assert (name instanceof String);
        return PageFlowUtils.getActionOutput((String)name, (ServletRequest)this._request);
    }

    public Set entrySet() {
        if (this._entrySet == null) {
            Map piMap = InternalUtils.getPageInputMap((ServletRequest)this._request);
            ArrayList<AbstractScriptableMap.Entry> list = new ArrayList<AbstractScriptableMap.Entry>();
            if (piMap != null) {
                for (Object name : piMap.keySet()) {
                    Object value = piMap.get(name);
                    list.add(new AbstractScriptableMap.Entry(name, value));
                }
            }
            this._entrySet = new AbstractScriptableMap.EntrySet(list.toArray(new AbstractScriptableMap.Entry[0]));
        }
        return this._entrySet;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ScriptablePageInput)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean containsKey(Object key) {
        Map piMap = InternalUtils.getPageInputMap((ServletRequest)this._request);
        return piMap != null ? piMap.containsKey(key) : false;
    }
}

