/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.el;

import javax.servlet.jsp.el.VariableResolver;
import org.apache.beehive.netui.script.Expression;
import org.apache.beehive.netui.script.ExpressionEngineFactory;
import org.apache.beehive.netui.script.ExpressionEvaluationException;
import org.apache.beehive.netui.script.ExpressionEvaluator;
import org.apache.beehive.netui.script.ExpressionUpdateException;
import org.apache.beehive.netui.script.IllegalExpressionException;
import org.apache.beehive.netui.script.el.ExpressionParseException;
import org.apache.beehive.netui.script.el.NetUIReadVariableResolver;
import org.apache.beehive.netui.script.el.NetUIVariableResolver;
import org.apache.beehive.netui.script.el.ParsedExpression;
import org.apache.beehive.netui.script.el.util.ParseUtils;
import org.apache.beehive.netui.util.logging.Logger;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private static final Logger _logger = Logger.getInstance(ExpressionEvaluatorImpl.class);
    private static final boolean DEBUG_ENABLED = _logger.isDebugEnabled();

    public Object evaluateStrict(String expression, VariableResolver variableResolver) throws ExpressionEvaluationException {
        NetUIReadVariableResolver vr = null;
        try {
            vr = new NetUIReadVariableResolver(variableResolver);
            return ParseUtils.evaluate(expression, vr);
        }
        catch (Exception e) {
            if (DEBUG_ENABLED) {
                _logger.debug((Object)("Expression evaluation failed in NetUIEL.  Cause: " + e), (Throwable)e);
            }
            Exception act = e;
            String contextStr = ParseUtils.getContextString(vr.getAvailableVariables());
            String msg = "Caught exception when evaluating expression \"" + expression + "\" with available binding contexts " + contextStr + ". Root cause: " + ParseUtils.getRootCause(act).toString();
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)act);
            }
            throw new ExpressionEvaluationException(msg, expression, act);
        }
    }

    public void update(String expression, Object value, VariableResolver variableResolver, boolean requestParameter) throws ExpressionUpdateException {
        assert (variableResolver instanceof NetUIVariableResolver);
        NetUIVariableResolver vr = (NetUIVariableResolver)variableResolver;
        try {
            if (DEBUG_ENABLED) {
                _logger.debug((Object)("Update expression \"" + expression + "\""));
            }
            ParseUtils.update(expression, value, vr);
        }
        catch (Exception e) {
            if (DEBUG_ENABLED) {
                _logger.debug((Object)("Expression update failed in NetUIEL.  Cause: " + e), (Throwable)e);
            }
            String contextStr = ParseUtils.getContextString(vr.getAvailableVariables());
            String msg = "Exception when attempting to update the expression \"" + expression + "\" with available binding contexts " + contextStr + ". Root cause: " + ParseUtils.getRootCause(e).toString();
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)e);
            }
            ExpressionUpdateException eee = new ExpressionUpdateException(msg, expression, e);
            eee.setLocalizedMessage(msg);
            throw eee;
        }
    }

    public String changeContext(String expression, String oldContext, String newContext, int lookupIndex) throws ExpressionEvaluationException {
        try {
            ParsedExpression pe = ParseUtils.parse(expression);
            return pe.changeContext(oldContext, newContext, new Integer(lookupIndex));
        }
        catch (Exception e) {
            String msg = "Error when trying to replace old context '" + oldContext + "' with new context '" + newContext + "' and index '" + lookupIndex + "': " + ParseUtils.getRootCause(e).toString();
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new ExpressionEvaluationException(msg, e);
        }
    }

    public String qualify(String contextName, String expression) throws ExpressionEvaluationException {
        try {
            ParsedExpression pe = ParseUtils.parse(expression);
            return pe.qualify(contextName);
        }
        catch (Exception e) {
            String msg = "Error when trying to create an expression in namespace \"" + contextName + "\" with fragment \"" + expression + "\".  Root cause: " + ParseUtils.getRootCause(e).toString();
            throw new ExpressionEvaluationException(msg, e);
        }
    }

    public boolean isExpression(String expression) {
        try {
            ParsedExpression pe = ParseUtils.parse(expression);
            return pe.isExpression();
        }
        catch (Exception e) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)("Exception parsing expression \"" + expression + "\".  Cause: " + ParseUtils.getRootCause(e).toString()), (Throwable)e);
            }
            if (e instanceof IllegalExpressionException) {
                throw (IllegalExpressionException)e;
            }
            if (e instanceof ExpressionParseException) {
                throw new IllegalExpressionException(e);
            }
            return false;
        }
    }

    public boolean containsExpression(String expression) {
        if (expression == null) {
            return false;
        }
        try {
            ParsedExpression pe = ParseUtils.parse(expression);
            assert (pe != null);
            return pe.containsExpression();
        }
        catch (Exception e) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)("Exception checking for expressions in \"" + expression + "\""), (Throwable)e);
            }
            return false;
        }
    }

    public Expression parseExpression(String expression) {
        if (this.isExpression(expression)) {
            ParsedExpression pe = ParseUtils.parse(expression);
            assert (pe != null);
            return pe.getAtomicExpressionTerm();
        }
        throw new IllegalExpressionException("The expression \"" + expression + "\" can not be parsed as it is not an atomic expression.");
    }

    public static class NetUIELEngineFactory
    extends ExpressionEngineFactory {
        public ExpressionEvaluator getInstance() {
            return new ExpressionEvaluatorImpl();
        }
    }
}

