/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.el;

import java.util.ArrayList;
import org.apache.beehive.netui.script.el.ExpressionTerm;
import org.apache.beehive.netui.script.el.LiteralTerm;
import org.apache.beehive.netui.script.el.NetUIVariableResolver;
import org.apache.beehive.netui.script.el.Term;
import org.apache.beehive.netui.util.logging.Logger;

public class ParsedExpression {
    private static Logger _logger = Logger.getInstance(ParsedExpression.class);
    private static final boolean DEBUG_ENABLED = _logger.isDebugEnabled();
    private static final String EMPTY_STRING = "";
    private ArrayList<Term> terms = new ArrayList(3);
    private boolean isExpression = false;
    private boolean containsExpression = false;
    private ExpressionTerm atomicExpression = null;
    private Term[] termArray = null;
    private String exprStr;

    public void seal() {
        this.termArray = new Term[this.terms.size()];
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.terms.size(); ++i) {
            String lit;
            Term t = this.terms.get(i);
            t.seal();
            if (t instanceof ExpressionTerm) {
                if (this.terms.size() == 1) {
                    this.atomicExpression = (ExpressionTerm)this.terms.get(0);
                    this.isExpression = true;
                }
                this.containsExpression = true;
            } else if (t instanceof LiteralTerm && (lit = t.getExpressionString()) != null && lit.indexOf("{") > -1) {
                this.containsExpression = true;
            }
            this.termArray[i] = this.terms.get(i);
            buf.append(t.getExpressionString());
        }
        this.exprStr = buf.toString();
    }

    public boolean isExpression() {
        return this.isExpression;
    }

    public boolean containsExpression() {
        return this.containsExpression;
    }

    public void addTerm(Term term) {
        this.terms.add(term);
    }

    public int getTokenCount() {
        return this.terms.size();
    }

    public Term getTerm(int i) {
        assert (this.termArray != null);
        assert (i > 0 && i < this.termArray.length);
        return this.termArray[i];
    }

    public ExpressionTerm getAtomicExpressionTerm() {
        return this.atomicExpression;
    }

    public Object evaluate(NetUIVariableResolver vr) {
        if (DEBUG_ENABLED) {
            _logger.debug((Object)("evaluate expression: " + this.exprStr));
        }
        if (this.isExpression) {
            if (DEBUG_ENABLED) {
                _logger.debug((Object)"atoimc expression");
            }
            return this.atomicExpression.evaluate(vr);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.terms.size(); ++i) {
            Object result;
            if (DEBUG_ENABLED) {
                _logger.debug((Object)("term[" + i + "]: " + this.termArray[i].getClass().getName() + " expression string: " + this.termArray[i].getExpressionString()));
            }
            buf.append((result = this.termArray[i].evaluate(vr)) != null ? result.toString() : EMPTY_STRING);
        }
        return buf.toString();
    }

    public void update(Object value, NetUIVariableResolver vr) {
        if (!this.isExpression) {
            String msg = "The expression can not be updated because it is not atomic.";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        this.atomicExpression.update(value, vr);
    }

    public String changeContext(String oldContext, String newContext, Object index) {
        if (!this.isExpression) {
            String msg = "The expression can not change context because it is not atomic.";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        return this.atomicExpression.changeContext(oldContext, newContext, index);
    }

    public String qualify(String contextName) {
        return "{" + contextName + "." + this.getExpressionString() + "}";
    }

    public String getExpressionString() {
        if (this.isExpression) {
            return this.atomicExpression.getExpressionString();
        }
        return this.exprStr;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Term term : this.terms) {
            builder.append(term.toString());
        }
        return builder.toString();
    }
}

