/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.script.el.tokens;

import java.util.List;
import org.apache.beehive.netui.script.el.tokens.ExpressionToken;
import org.apache.beehive.netui.util.logging.Logger;

public class ArrayIndexToken
extends ExpressionToken {
    private static final Logger _logger = Logger.getInstance(ArrayIndexToken.class);
    private int index;

    public ArrayIndexToken(String identifier) {
        this.index = Integer.parseInt(identifier);
    }

    public void update(Object root, Object newValue) {
        if (root instanceof List) {
            this.listUpdate((List)root, this.index, newValue);
        } else if (root.getClass().isArray()) {
            this.arrayUpdate(root, this.index, newValue);
        } else {
            RuntimeException re = new RuntimeException("The index \"" + this.index + "\" can not be used to look-up the type of a property" + " on an object that is not an array or list.");
            _logger.error((Object)"", (Throwable)re);
            throw re;
        }
    }

    public Object evaluate(Object value) {
        if (value instanceof List) {
            return this.listLookup((List)value, this.index);
        }
        if (value.getClass().isArray()) {
            return this.arrayLookup(value, this.index);
        }
        RuntimeException re = new RuntimeException("The index \"" + this.index + "\" can not be used to look-up a property on an object that is not an array or list.");
        _logger.error((Object)"", (Throwable)re);
        throw re;
    }

    public String getTokenString() {
        return "[" + this.index + "]";
    }

    public String toString() {
        return "" + this.index;
    }
}

