/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.autoconfigure;

import cool.cena.openai.OpenAiSource;
import cool.cena.openai.autoconfigure.OpenAiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OpenAiProperties.class})
public class OpenAiAutoConfiguration {
    @Autowired
    OpenAiProperties properties;

    @Bean
    @ConditionalOnProperty(prefix="openai", name={"organization"}, havingValue="ConditionalOnMissingProperty", matchIfMissing=true)
    public OpenAiSource configureOpenAiApiAccessor() {
        String httpHeaderAuthorization = "Bearer " + this.properties.getKey();
        return new OpenAiSource(httpHeaderAuthorization, this.properties);
    }

    @Bean
    @ConditionalOnProperty(prefix="openai", name={"organization"})
    public OpenAiSource configureOpenAiApiAccessorWithOrganization() {
        String httpHeaderAuthorization = "Bearer " + this.properties.getKey();
        String httpHeaderOpenAiOrganization = this.properties.getOrganization();
        return new OpenAiSource(httpHeaderAuthorization, httpHeaderOpenAiOrganization, this.properties);
    }
}

