/*
 * Decompiled with CFR 0.152.
 */
package cool.graph.cuid;

import java.lang.management.ManagementFactory;
import java.util.Date;

public class Cuid {
    private static final int BASE = 36;
    private static final int BLOCK_SIZE = 4;
    private static final int DISCRETE_VALUES = (int)Math.pow(36.0, 4.0);
    private static final String LETTER = "c";
    private static final String FINGERPRINT = Cuid.getFingerprint();
    private static int counter = 0;

    private static String getHostInfo(String idFallback, String nameFallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return String.format("%s@%s", idFallback, nameFallback);
        }
        return jvmName;
    }

    private static String getFingerprint() {
        String hostInfo = Cuid.getHostInfo(Long.toString(new Date().getTime()), "dummy-host");
        String hostId = hostInfo.split("@")[0];
        String hostname = hostInfo.split("@")[1];
        int acc = hostname.length() + 36;
        for (int i = 0; i < hostname.length(); ++i) {
            acc += acc + hostname.charAt(i);
        }
        String idBlock = Cuid.pad(Long.toString(Long.parseLong(hostId), 36), 2);
        String nameBlock = Cuid.pad(Integer.toString(acc), 2);
        return idBlock + nameBlock;
    }

    private static String pad(String input, int size) {
        String repeatedZero = new String(new char[size]).replace("\u0000", "0");
        String padded = repeatedZero + input;
        return padded.substring(padded.length() - size);
    }

    private static String getRandomBlock() {
        return Cuid.pad(Integer.toString((int)(Math.random() * (double)DISCRETE_VALUES), 36), 4);
    }

    private static int safeCounter() {
        counter = counter < DISCRETE_VALUES ? counter : 0;
        return counter++;
    }

    public static String createCuid() {
        String timestamp = Long.toString(new Date().getTime(), 36);
        String counter = Cuid.pad(Integer.toString(Cuid.safeCounter(), 36), 4);
        String random = Cuid.getRandomBlock() + Cuid.getRandomBlock();
        return LETTER + timestamp + counter + FINGERPRINT + random;
    }
}

