/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher;

import cool.scx.live_room_watcher.AccessToken;
import cool.scx.live_room_watcher.util.Helper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccessTokenManager {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String accessToken;

    protected abstract AccessToken getAccessToken0() throws IOException, InterruptedException;

    public synchronized String getAccessToken() {
        if (this.accessToken == null) {
            this.refreshAccessToken();
        }
        return this.accessToken;
    }

    public synchronized void refreshAccessToken() {
        try {
            AccessToken accessToken0 = this.getAccessToken0();
            this.logger.debug("\u83b7\u53d6 accessToken \u6210\u529f : {}", (Object)accessToken0);
            this.accessToken = accessToken0.accessToken();
            Helper.SCHEDULER.schedule(this::refreshAccessToken, accessToken0.expiresIn() / 2L, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            Helper.SCHEDULER.schedule(this::refreshAccessToken, 2000L, TimeUnit.SECONDS);
        }
    }
}

