/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher.impl._560game;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.RandomUtils;
import cool.scx.http.HttpMethod;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.helidon.ScxHttpClientHelper;
import cool.scx.live_room_watcher.AbstractLiveRoomWatcher;
import cool.scx.live_room_watcher.impl._560game._560GameHelper;
import cool.scx.live_room_watcher.impl._560game._560GameWatchTask;
import cool.scx.live_room_watcher.impl._560game._560GiftListEntry;
import cool.scx.live_room_watcher.impl._560game.message._560GameChat;
import cool.scx.live_room_watcher.impl._560game.message._560GameFollow;
import cool.scx.live_room_watcher.impl._560game.message._560GameGift;
import cool.scx.live_room_watcher.impl._560game.message._560GameLike;
import cool.scx.live_room_watcher.impl._560game.message._560GameUser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class _560GameLiveRoomWatcher
extends AbstractLiveRoomWatcher {
    private final String mch_id;
    private final String game_id;
    private final String secret;
    private final Map<String, _560GameWatchTask> watchTaskMap = new ConcurrentHashMap<String, _560GameWatchTask>();
    private String root_uri;

    public _560GameLiveRoomWatcher(String mch_id, String game_id, String secret) {
        this.mch_id = mch_id;
        this.game_id = game_id;
        this.secret = secret;
        this.root_uri = "https://danmu.fa-pay.com";
    }

    public String getRootURI() {
        return this.root_uri;
    }

    public void setRootURI(String root_url) {
        this.root_uri = root_url;
    }

    public void startWatch(String username, String password) throws IOException, InterruptedException {
        _560GameWatchTask w = this.watchTaskMap.get(username);
        if (w == null) {
            _560GameWatchTask watchTask = new _560GameWatchTask(username, password, this);
            this.watchTaskMap.put(username, watchTask);
            watchTask.start();
        } else {
            w.start();
        }
    }

    public void stopWatch(String username) throws IOException, InterruptedException {
        _560GameWatchTask watchTask = this.watchTaskMap.get(username);
        if (watchTask != null) {
            watchTask.stop();
            this.watchTaskMap.remove(username);
        }
    }

    public String validateUser(String username, String password) {
        try {
            return this.validateUser0(username, password);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String validateUser0(String username, String password) throws IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mch_id", this.mch_id);
        map.put("username", username);
        map.put("password", password);
        map.put("game_id", this.game_id);
        map.put("nonce", RandomUtils.randomString((int)32));
        String sign = _560GameHelper.getSign(map, this.secret);
        map.put("sign", sign);
        ScxHttpClientResponse response = ScxHttpClientHelper.request().method(HttpMethod.POST).uri(this.root_uri + "/barrgame/grant_api/validateUser").send(map);
        JsonNode jsonNode = response.body().asJsonNode();
        String message = jsonNode.get("message").asText();
        if (!"success".equals(message)) {
            throw new RuntimeException("\u8fd4\u56de\u6570\u636e\u6709\u8bef : " + String.valueOf(jsonNode));
        }
        return jsonNode.get("data").get("ws_url").asText();
    }

    public JsonNode closeGameNotify(String username) {
        try {
            return this.closeGameNotify0(username);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode closeGameNotify0(String username) throws IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mch_id", this.mch_id);
        map.put("username", username);
        map.put("game_id", this.game_id);
        map.put("nonce", RandomUtils.randomString((int)32));
        String sign = _560GameHelper.getSign(map, this.secret);
        map.put("sign", sign);
        ScxHttpClientResponse response = ScxHttpClientHelper.request().method(HttpMethod.POST).uri(this.root_uri + "/barrgame/grant_api/closeGameNotify").send(map);
        JsonNode jsonNode = response.body().asJsonNode();
        String message = jsonNode.get("message").asText();
        if (!"success".equals(message)) {
            throw new RuntimeException("\u8fd4\u56de\u6570\u636e\u6709\u8bef");
        }
        return jsonNode;
    }

    public JsonNode reportGameNotify(String username) {
        try {
            return this.reportGameNotify0(username);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode reportGameNotify0(String username) throws IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mch_id", this.mch_id);
        map.put("username", username);
        map.put("game_id", this.game_id);
        map.put("nonce", RandomUtils.randomString((int)32));
        String sign = _560GameHelper.getSign(map, this.secret);
        map.put("sign", sign);
        ScxHttpClientResponse response = ScxHttpClientHelper.request().method(HttpMethod.POST).uri(this.root_uri + "/barrgame/grant_api/reportGameNotify").send(map);
        JsonNode jsonNode = response.body().asJsonNode();
        String message = jsonNode.get("message").asText();
        if (!"success".equals(message)) {
            throw new RuntimeException("\u8fd4\u56de\u6570\u636e\u6709\u8bef");
        }
        return jsonNode;
    }

    public List<_560GiftListEntry> getGiftList() throws IOException, InterruptedException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mch_id", this.mch_id);
        map.put("game_id", this.game_id);
        map.put("nonce", RandomUtils.randomString((int)32));
        String sign = _560GameHelper.getSign(map, this.secret);
        map.put("sign", sign);
        ScxHttpClientResponse response = ScxHttpClientHelper.request().method(HttpMethod.POST).uri(this.root_uri + "/barrgame/grant_api/getGiftList").send(map);
        JsonNode jsonNode = response.body().asJsonNode();
        String message = jsonNode.get("message").asText();
        if (!"success".equals(message)) {
            throw new RuntimeException("\u8fd4\u56de\u6570\u636e\u6709\u8bef");
        }
        return (List)ObjectUtils.convertValue((Object)jsonNode.get("data"), (TypeReference)new TypeReference<List<_560GiftListEntry>>(this){});
    }

    void callMessage(JsonNode jsonNode) {
        int MsgType = jsonNode.get("MsgType").asInt();
        switch (MsgType) {
            case 2: {
                this.callGift(jsonNode);
                break;
            }
            case 3: {
                this.callLike(jsonNode);
                break;
            }
            case 4: {
                this.callChat(jsonNode);
                break;
            }
            case 5: {
                this.callFollow(jsonNode);
                break;
            }
            case 6: {
                this.callUser(jsonNode);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u77e5 MsgType : " + MsgType);
            }
        }
    }

    private void callGift(JsonNode jsonNode) {
        _560GameGift gift = (_560GameGift)ObjectUtils.convertValue((Object)jsonNode, _560GameGift.class);
        this._callOnGift(gift);
    }

    private void callLike(JsonNode jsonNode) {
        _560GameLike like = (_560GameLike)ObjectUtils.convertValue((Object)jsonNode, _560GameLike.class);
        this._callOnLike(like);
    }

    private void callChat(JsonNode jsonNode) {
        _560GameChat chat = (_560GameChat)ObjectUtils.convertValue((Object)jsonNode, _560GameChat.class);
        this._callOnChat(chat);
    }

    private void callFollow(JsonNode jsonNode) {
        _560GameFollow follow = (_560GameFollow)ObjectUtils.convertValue((Object)jsonNode, _560GameFollow.class);
        this._callOnFollow(follow);
    }

    private void callUser(JsonNode jsonNode) {
        _560GameUser user = (_560GameUser)ObjectUtils.convertValue((Object)jsonNode, _560GameUser.class);
        this._callOnUser(user);
    }
}

