/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher.impl._560game;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.scx.common.util.$;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.http.ScxClientWebSocketBuilder;
import cool.scx.http.ScxWebSocket;
import cool.scx.http.helidon.ScxHttpClientHelper;
import cool.scx.http.uri.ScxURI;
import cool.scx.live_room_watcher.impl._560game._560GameHelper;
import cool.scx.live_room_watcher.impl._560game._560GameLiveRoomWatcher;

public class _560GameWatchTask {
    private static final System.Logger logger = System.getLogger(_560GameWatchTask.class.getName());
    private final int pingIntervalTime;
    private final int pingTimeoutTime;
    private final String username;
    private final String password;
    private final _560GameLiveRoomWatcher watcher;
    private ScxClientWebSocketBuilder webSocketFuture;
    private ScxWebSocket webSocket;
    private $.Timeout ping;
    private $.Timeout pingTimeout;

    public _560GameWatchTask(String username, String password, _560GameLiveRoomWatcher watcher) {
        this.username = username;
        this.password = password;
        this.watcher = watcher;
        this.pingIntervalTime = 5000;
        this.pingTimeoutTime = 5000;
    }

    public static void callOffline(JsonNode args) {
    }

    public void start() {
        this.stop();
        String s = this.watcher.validateUser(this.username, this.password);
        ScxURI ws_url = _560GameHelper.getWsUrl(s, this.username);
        logger.log(System.Logger.Level.DEBUG, "\u8fde\u63a5\u5f00\u59cb \u5730\u5740" + String.valueOf(ws_url));
        this.webSocketFuture = ScxHttpClientHelper.webSocket().uri(ws_url);
        this.webSocketFuture.onConnect(ws -> {
            this.webSocket = ws;
            logger.log(System.Logger.Level.DEBUG, "\u8fde\u63a5\u6210\u529f ");
            ws.onTextMessage(c -> Thread.ofVirtual().start(() -> {
                this.startPing();
                this.startPingTimeout();
                logger.log(System.Logger.Level.DEBUG, "\u6536\u5230\u6d88\u606f {0}", c);
                try {
                    JsonNode jsonNode = (JsonNode)ScxExceptionHelper.wrap(() -> ObjectUtils.jsonMapper().readTree(c));
                    ((ObjectNode)jsonNode).put("roomID", this.username);
                    int MsgType = jsonNode.get("MsgType").asInt();
                    switch (MsgType) {
                        case 7: {
                            _560GameWatchTask.callOffline(jsonNode);
                            break;
                        }
                        case 8: {
                            this.callPong(jsonNode);
                            break;
                        }
                        default: {
                            this.watcher.callMessage(jsonNode);
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    logger.log(System.Logger.Level.ERROR, "\u8c03\u7528 callMessage \u53d1\u751f\u9519\u8bef :", e);
                }
            }));
            ws.onClose((v, a) -> {
                logger.log(System.Logger.Level.DEBUG, "\u8fde\u63a5\u5173\u95ed ");
                this.start();
            });
            ws.onError(e -> {
                logger.log(System.Logger.Level.ERROR, "\u8fde\u63a5\u5f02\u5e38 :", (Throwable)e);
                this.start();
            });
        });
        try {
            this.webSocketFuture.connect();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            this.start();
        }
        this.startPing();
        this.startPingTimeout();
    }

    public void stop() {
        this.stopWebSocket();
        this.cancelPing();
        this.cancelPingTimeout();
    }

    public void stopWebSocket() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.onClose((c, a) -> {});
            this.webSocket.onError(c -> {});
            this.webSocket.close();
            logger.log(System.Logger.Level.DEBUG, "\u5173\u95ed\u6210\u529f");
            this.webSocket = null;
        }
    }

    private void startPingTimeout() {
        this.cancelPingTimeout();
        this.pingTimeout = $.setTimeout(this::doPingTimeout, (long)(this.pingTimeoutTime + this.pingIntervalTime));
    }

    protected void startPing() {
        this.cancelPing();
        this.ping = $.setTimeout(() -> {
            this.sendPing();
            this.startPing();
        }, (long)this.pingIntervalTime);
    }

    private void sendPing() {
        block3: {
            try {
                ScxWebSocket sendPingFuture = this.webSocket.send("ping");
                if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                    logger.log(System.Logger.Level.DEBUG, "\u53d1\u9001 ping \u6210\u529f");
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(System.Logger.Level.DEBUG)) break block3;
                logger.log(System.Logger.Level.DEBUG, "\u53d1\u9001 ping \u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void cancelPing() {
        if (this.ping != null) {
            this.ping.cancel();
            this.ping = null;
        }
    }

    public void callPong(JsonNode args) {
    }

    private void cancelPingTimeout() {
        if (this.pingTimeout != null) {
            this.pingTimeout.cancel();
            this.pingTimeout = null;
        }
    }

    protected void doPingTimeout() {
        this.start();
    }
}

