/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher.impl.douyin;

import cool.scx.common.util.Base64Utils;
import cool.scx.common.util.HashUtils;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class DouYinHelper {
    DouYinHelper() {
    }

    public static void checkDouYinData(String bodyStr, Map<String, String> headers, String dataSecret) {
        String x_nonce_str = headers.get("x-nonce-str");
        String x_timestamp = headers.get("x-timestamp");
        String x_signature = headers.get("x-signature");
        String x_roomid = headers.get("x-roomid");
        String x_msg_type = headers.get("x-msg-type");
        if (x_nonce_str == null || x_timestamp == null || x_signature == null || x_roomid == null || x_msg_type == null) {
            throw new InvalidParameterException("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef\uff01\uff01\uff01");
        }
        Map<String, String> s = Map.of("x-nonce-str", x_nonce_str, "x-timestamp", x_timestamp, "x-roomid", x_roomid, "x-msg-type", x_msg_type);
        String s1 = DouYinHelper.signature(s, bodyStr, dataSecret);
        if (!Objects.equals(s1, x_signature)) {
            throw new InvalidParameterException("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef\uff01\uff01\uff01");
        }
    }

    private static String signature(Map<String, String> header, String bodyStr, String secret) {
        String urlParams = header.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(k -> (String)k.getKey() + "=" + (String)k.getValue()).collect(Collectors.joining("&"));
        String rawData = urlParams + bodyStr + secret;
        byte[] md5Bytes = HashUtils.md5((byte[])rawData.getBytes());
        return Base64Utils.encodeToString((byte[])md5Bytes);
    }
}

