/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher.impl.douyin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.HttpMethod;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.ScxMediaType;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.helidon.ScxHttpClientHelper;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.live_room_watcher.AbstractLiveRoomWatcher;
import cool.scx.live_room_watcher.impl.douyin.DouYinAccessTokenManager;
import cool.scx.live_room_watcher.impl.douyin.DouYinHelper;
import cool.scx.live_room_watcher.impl.douyin.DouYinMsgType;
import cool.scx.live_room_watcher.impl.douyin.DouYinResponseBody;
import cool.scx.live_room_watcher.impl.douyin.DouYinWebcastMateInfo;
import cool.scx.live_room_watcher.impl.douyin.message.DouYinChat;
import cool.scx.live_room_watcher.impl.douyin.message.DouYinGift;
import cool.scx.live_room_watcher.impl.douyin.message.DouYinLike;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class DouYinLiveRoomWatcher
extends AbstractLiveRoomWatcher {
    public final Map<String, String> giftNameMap;
    private final String appID;
    private final String appSecret;
    private final String commentDataSecret;
    private final String giftDataSecret;
    private final String likeDataSecret;
    private final DouYinAccessTokenManager accessTokenManager;

    public DouYinLiveRoomWatcher(String appID, String appSecret, String commentDataSecret, String giftDataSecret, String likeDataSecret, Map<String, String> giftNameMap) {
        this.appID = appID;
        this.appSecret = appSecret;
        this.commentDataSecret = commentDataSecret;
        this.giftDataSecret = giftDataSecret;
        this.likeDataSecret = likeDataSecret;
        this.giftNameMap = giftNameMap;
        if (appID == null || appSecret == null || commentDataSecret == null || giftDataSecret == null || likeDataSecret == null || giftNameMap == null) {
            throw new RuntimeException();
        }
        this.accessTokenManager = new DouYinAccessTokenManager(appID, appSecret);
    }

    public DouYinWebcastMateInfo liveInfo(String token) throws IOException, InterruptedException {
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri("https://webcast.bytedance.com/api/webcastmate/info").method(HttpMethod.POST).setHeader("X-Token", new String[]{this.accessTokenManager.getAccessToken()}).contentType((ContentType)ContentType.of((ScxMediaType)MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8)).send(ObjectUtils.toJson(Map.of("token", token)));
        String bodyStr = response.body().toString();
        JsonNode jsonNode = ObjectUtils.jsonMapper().readTree(bodyStr);
        JsonNode data = jsonNode.get("data");
        if (data == null) {
            throw new RuntimeException("webcastMateInfo \u8bfb\u53d6\u6570\u636e\u6709\u8bef, \u9519\u8bef\u7684 \u8fd4\u56de\u503c : " + bodyStr);
        }
        JsonNode info = data.get("info");
        if (info == null) {
            throw new RuntimeException("webcastMateInfo \u8bfb\u53d6\u6570\u636e\u6709\u8bef, \u9519\u8bef\u7684 \u8fd4\u56de\u503c : " + bodyStr);
        }
        return (DouYinWebcastMateInfo)ObjectUtils.jsonMapper().convertValue((Object)info, DouYinWebcastMateInfo.class);
    }

    public DouYinResponseBody taskStart(String roomID, DouYinMsgType msgType) throws IOException, InterruptedException {
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri("https://webcast.bytedance.com/api/live_data/task/start").method(HttpMethod.POST).setHeader("access-token", new String[]{this.accessTokenManager.getAccessToken()}).send(Map.of("roomid", roomID, "appid", this.appID, "msg_type", msgType.value()));
        String bodyStr = response.body().toString();
        return (DouYinResponseBody)ObjectUtils.jsonMapper().readValue(bodyStr, DouYinResponseBody.class);
    }

    public DouYinResponseBody taskStop(String roomCode, DouYinMsgType msgType) throws IOException, InterruptedException {
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri("https://webcast.bytedance.com/api/live_data/task/stop").method(HttpMethod.POST).setHeader("access-token", new String[]{this.accessTokenManager.getAccessToken()}).send(Map.of("roomid", roomCode, "appid", this.appID, "msg_type", msgType.value()));
        return (DouYinResponseBody)response.body().asObject(DouYinResponseBody.class);
    }

    public DouYinResponseBody taskStatus(String roomCode, DouYinMsgType msgType) throws IOException, InterruptedException {
        ScxURIWritable uri = ScxURI.of((String)"https://webcast.bytedance.com/api/live_data/task/get").addQuery("roomid", new String[]{roomCode}).addQuery("appid", new String[]{this.appID}).addQuery("msg_type", new String[]{msgType.value()});
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri(uri).method(HttpMethod.GET).setHeader("access-token", new String[]{this.accessTokenManager.getAccessToken()}).send();
        return (DouYinResponseBody)response.body().asObject(DouYinResponseBody.class);
    }

    public DouYinResponseBody failDataGet(String roomCode, DouYinMsgType msg_type, Integer page_num, Integer page_size) throws IOException, InterruptedException {
        ScxURIWritable uri = ScxURI.of((String)"https://webcast.bytedance.com/api/live_data/task/fail_data/get").addQuery("roomid", new String[]{roomCode}).addQuery("appid", new String[]{this.appID}).addQuery("msg_type", new String[]{msg_type.value()}).addQuery("page_num", new Object[]{page_num}).addQuery("page_size", new Object[]{page_size});
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri(uri).method(HttpMethod.GET).setHeader("access-token", new String[]{this.accessTokenManager.getAccessToken()}).send();
        return (DouYinResponseBody)response.body().asObject(DouYinResponseBody.class);
    }

    public DouYinResponseBody topGift(String roomCode, String[] secGiftIDList) throws IOException, InterruptedException {
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri("https://webcast.bytedance.com/api/gift/top_gift").method(HttpMethod.POST).setHeader("x-token", new String[]{this.accessTokenManager.getAccessToken()}).send(Map.of("room_id", roomCode, "app_id", this.appID, "sec_gift_id_list", secGiftIDList));
        return (DouYinResponseBody)response.body().asObject(DouYinResponseBody.class);
    }

    public DouYinResponseBody fansClubGetInfo(String roomCode, String anchor_openid, String[] user_openids) throws IOException, InterruptedException {
        ScxURIWritable uri = ScxURI.of((String)"https://webcast.bytedance.com/api/live_data/fans_club/get_info").addQuery("roomid", new String[]{roomCode}).addQuery("anchor_openid", new String[]{anchor_openid}).addQuery("user_openids", new String[]{String.join((CharSequence)",", user_openids)});
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri(uri).method(HttpMethod.GET).setHeader("access-token", new String[]{this.accessTokenManager.getAccessToken()}).send();
        return (DouYinResponseBody)response.body().asObject(DouYinResponseBody.class);
    }

    public void taskStartAll(String roomID) throws IOException, InterruptedException {
        this.taskStart(roomID, DouYinMsgType.LIVE_COMMENT);
        this.taskStart(roomID, DouYinMsgType.LIVE_GIFT);
        this.taskStart(roomID, DouYinMsgType.LIVE_LIKE);
        this.taskStart(roomID, DouYinMsgType.LIVE_FANSCLUB);
    }

    public void taskStopAll(String roomID) throws IOException, InterruptedException {
        this.taskStop(roomID, DouYinMsgType.LIVE_COMMENT);
        this.taskStop(roomID, DouYinMsgType.LIVE_GIFT);
        this.taskStop(roomID, DouYinMsgType.LIVE_LIKE);
        this.taskStop(roomID, DouYinMsgType.LIVE_FANSCLUB);
    }

    public void callChat(String bodyStr, Map<String, String> header) throws JsonProcessingException {
        DouYinChat[] commentList;
        String roomID = header.get("x-roomid");
        DouYinHelper.checkDouYinData(bodyStr, header, this.commentDataSecret);
        for (DouYinChat comment : commentList = (DouYinChat[])ObjectUtils.jsonMapper().readValue(bodyStr, (TypeReference)new TypeReference<DouYinChat[]>(this){})) {
            comment.roomID = roomID;
            this._callOnChat(comment);
        }
    }

    public void callLike(String bodyStr, Map<String, String> header) throws JsonProcessingException {
        DouYinLike[] likeList;
        String roomID = header.get("x-roomid");
        DouYinHelper.checkDouYinData(bodyStr, header, this.likeDataSecret);
        for (DouYinLike like : likeList = (DouYinLike[])ObjectUtils.jsonMapper().readValue(bodyStr, (TypeReference)new TypeReference<DouYinLike[]>(this){})) {
            like.roomID = roomID;
            this._callOnLike(like);
        }
    }

    public void callGift(String bodyStr, Map<String, String> header) throws JsonProcessingException {
        DouYinGift[] giftList;
        String roomID = header.get("x-roomid");
        DouYinHelper.checkDouYinData(bodyStr, header, this.giftDataSecret);
        for (DouYinGift gift : giftList = (DouYinGift[])ObjectUtils.jsonMapper().readValue(bodyStr, (TypeReference)new TypeReference<DouYinGift[]>(this){})) {
            gift.gift_name = this.giftNameMap.get(gift.sec_gift_id);
            gift.roomID = roomID;
            this._callOnGift(gift);
        }
    }
}

