/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher.impl.douyin_hack;

import com.google.protobuf.InvalidProtocolBufferException;
import cool.scx.common.functional.ScxConsumer;
import cool.scx.common.util.$;
import cool.scx.http.HttpMethod;
import cool.scx.http.ScxClientWebSocketBuilder;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.ScxWebSocket;
import cool.scx.http.cookie.Cookie;
import cool.scx.live_room_watcher.AbstractLiveRoomWatcher;
import cool.scx.live_room_watcher.impl.douyin_hack.DouYinHackHelper;
import cool.scx.live_room_watcher.impl.douyin_hack.DouYinHackLiveRoomInfo;
import cool.scx.live_room_watcher.impl.douyin_hack.PushFrameAndResponse;
import cool.scx.live_room_watcher.impl.douyin_hack.enumeration.ControlMessageAction;
import cool.scx.live_room_watcher.impl.douyin_hack.enumeration.MemberMessageAction;
import cool.scx.live_room_watcher.impl.douyin_hack.message.DouYinHackChat;
import cool.scx.live_room_watcher.impl.douyin_hack.message.DouYinHackFollow;
import cool.scx.live_room_watcher.impl.douyin_hack.message.DouYinHackGift;
import cool.scx.live_room_watcher.impl.douyin_hack.message.DouYinHackLike;
import cool.scx.live_room_watcher.impl.douyin_hack.message.DouYinHackUser;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.ChatMessage;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.ControlMessage;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.GiftMessage;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.LikeMessage;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.MemberMessage;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.Message;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.PushFrame;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.Response;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.RoomRankMessage;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.RoomStatsMessage;
import cool.scx.live_room_watcher.impl.douyin_hack.proto_entity.webcast.im.SocialMessage;
import cool.scx.live_room_watcher.util.Browser;
import cool.scx.live_room_watcher.util.Navigator;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DouYinHackLiveRoomWatcher
extends AbstractLiveRoomWatcher {
    private final String liveRoomURI;
    private final Browser browser;
    private final Map<String, ScxConsumer<byte[], ?>> handlerMap;
    private ScxWebSocket webSocket;
    private boolean useGzip;
    private Thread ping;
    private DouYinHackLiveRoomInfo liveRoomInfo;

    public DouYinHackLiveRoomWatcher(String uri) {
        this.liveRoomURI = DouYinHackHelper.initLiveRoomURI(uri);
        this.browser = new Browser().addCookie((Cookie)Cookie.of((String)"__ac_nonce", (String)"063b51155007d27728929"));
        this.handlerMap = this.initHandlerMap();
    }

    public Map<String, ScxConsumer<byte[], ?>> initHandlerMap() {
        HashMap map = new HashMap();
        map.put("WebcastSocialMessage", this::WebcastSocialMessage);
        map.put("WebcastChatMessage", this::WebcastChatMessage);
        map.put("WebcastMemberMessage", this::WebcastMemberMessage);
        map.put("WebcastLikeMessage", this::WebcastLikeMessage);
        map.put("WebcastGiftMessage", this::WebcastGiftMessage);
        map.put("WebcastControlMessage", this::WebcastControlMessage);
        map.put("WebcastRoomRankMessage", this::WebcastRoomRankMessage);
        map.put("WebcastRoomStatsMessage", this::WebcastRoomStatsMessage);
        return map;
    }

    private void startPing(ScxWebSocket ws) {
        if (this.ping != null) {
            this.ping.interrupt();
        }
        this.ping = new Thread(() -> {
            while (true) {
                byte[] ping = PushFrame.newBuilder().setPayloadType("hb").build().toByteArray();
                ws.send(ping);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        this.ping.start();
    }

    private ScxHttpClientResponse getIndexHtml(String liveRoomURI) throws IOException, InterruptedException {
        return this.browser.request().method(HttpMethod.GET).uri(liveRoomURI).setHeader("User-Agent", new String[]{Navigator.navigator().userAgent()}).setHeader("accept", new String[]{"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9"}).send();
    }

    public DouYinHackLiveRoomInfo getLiveRoomInfo() throws IOException, InterruptedException {
        ScxHttpClientResponse indexHtml = this.getIndexHtml(this.liveRoomURI);
        return new DouYinHackLiveRoomInfo(indexHtml.body().toString());
    }

    public void startWatch() {
        new Thread(() -> {
            while (true) {
                $.sleep((long)99999L);
            }
        }).start();
        this.stopWatch();
        try {
            System.out.println("\u89e3\u6790\u4e2d...");
            this.liveRoomInfo = this.getLiveRoomInfo();
            System.out.println("\u89e3\u6790\u5b8c\u6210 -> " + this.liveRoomInfo.title() + " (ID : " + this.liveRoomInfo.roomID() + ")");
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790 \u76f4\u64ad\u95f4\u9519\u8bef !!!", e);
        }
        System.out.println("\u8fde\u63a5\u4e2d...");
        ScxClientWebSocketBuilder webSocketFuture = this.browser.webSocket(DouYinHackHelper.getWebSocketOptions(this.liveRoomURI));
        webSocketFuture.onConnect(c -> {
            this.webSocket = c;
            this.startPing((ScxWebSocket)c);
            c.onBinaryMessage(b -> {
                PushFrameAndResponse v = this.parseFrame((byte[])b);
                if (v.response().getNeedAck()) {
                    DouYinHackHelper.sendAck((ScxWebSocket)c, v.pushFrame(), v.response());
                }
            });
            c.onTextMessage(System.out::println);
            c.onError(e -> {
                e.printStackTrace();
                this.startWatch();
            });
            System.out.println("\u8fde\u63a5\u6210\u529f !!!");
        });
        try {
            webSocketFuture.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.startWatch();
        }
    }

    public void stopWatch() {
        if (this.webSocket != null) {
            this.webSocket.onError(e -> {});
            this.webSocket.close();
            this.webSocket = null;
        }
        if (this.ping != null) {
            this.ping.interrupt();
        }
    }

    private void callHandler(Message message) throws Exception {
        byte[] payload = message.getPayload().toByteArray();
        String method = message.getMethod();
        ScxConsumer handler = this.handlerMap.getOrDefault(method, this::DefaultHandler);
        handler.accept((Object)payload);
    }

    private void DefaultHandler(byte[] bytes) {
    }

    public void WebcastSocialMessage(byte[] payload) throws InvalidProtocolBufferException {
        SocialMessage socialMessage = SocialMessage.parseFrom(payload);
        DouYinHackFollow douYinFollow = new DouYinHackFollow(socialMessage);
        this._callOnFollow(douYinFollow);
    }

    public void WebcastChatMessage(byte[] payload) throws InvalidProtocolBufferException {
        ChatMessage chatMessage = ChatMessage.parseFrom(payload);
        DouYinHackChat douYinChat = new DouYinHackChat(chatMessage);
        this._callOnChat(douYinChat);
    }

    public void WebcastMemberMessage(byte[] payload) throws InvalidProtocolBufferException {
        MemberMessage memberMessage = MemberMessage.parseFrom(payload);
        long actionCode = memberMessage.getAction();
        MemberMessageAction action = MemberMessageAction.of(actionCode);
        switch (action) {
            case SET_SILENCE: 
            case MANAGER_SET_SILENCE: {
                System.out.println("SET_SILENCE");
                break;
            }
            case CANCEL_SILENCE: 
            case MANAGER_CANCEL_SILENCE: {
                System.out.println("CANCEL_SILENCE");
                break;
            }
            case BLOCK: {
                System.out.println("BLOCK");
                break;
            }
            case KICK_OUT: {
                System.out.println("KICK_OUT");
                break;
            }
            case ENTER: {
                break;
            }
            case LEAVE: {
                System.out.println("LEAVE");
                break;
            }
            case SET_ADMIN: {
                break;
            }
            case CANCEL_ADMIN: {
                break;
            }
            case SHARE: {
                break;
            }
        }
        DouYinHackUser douYinUser = new DouYinHackUser(memberMessage);
        this._callOnUser(douYinUser);
    }

    public void WebcastLikeMessage(byte[] payload) throws InvalidProtocolBufferException {
        LikeMessage likeMessage = LikeMessage.parseFrom(payload);
        DouYinHackLike douYinLike = new DouYinHackLike(likeMessage);
        this._callOnLike(douYinLike);
    }

    public void WebcastGiftMessage(byte[] payload) throws InvalidProtocolBufferException {
        GiftMessage giftMessage = GiftMessage.parseFrom(payload);
        String name = giftMessage.getGift().getName();
        DouYinHackGift douYinGift = new DouYinHackGift(giftMessage);
        this._callOnGift(douYinGift);
    }

    public void WebcastControlMessage(byte[] payload) throws InvalidProtocolBufferException {
        ControlMessage controlMessage = ControlMessage.parseFrom(payload);
        long actionCode = controlMessage.getAction();
        ControlMessageAction action = ControlMessageAction.of(actionCode);
        switch (action) {
            case FINISH: 
            case FINISH_BY_ADMIN: 
            case ROOM_FINISH_BY_SWITCH: {
                System.out.println("\u76f4\u64ad\u5df2\u7ed3\u675f !!!");
                break;
            }
            case RESUME: {
                System.out.println("RESUME");
                break;
            }
            case PAUSE: {
                System.out.println("\u6682\u505c");
            }
        }
    }

    public void WebcastRoomRankMessage(byte[] payload) throws InvalidProtocolBufferException {
        RoomRankMessage roomRankMessage = RoomRankMessage.parseFrom(payload);
        StringBuilder sb = new StringBuilder("\u623f\u95f4\u6392\u884c\u699c\u66f4\u65b0 : \n");
        int index = 1;
        for (RoomRankMessage.RoomRank roomRank : roomRankMessage.getRanksList()) {
            sb.append(index).append(" : ").append(roomRank.getUser().getNickname()).append("\n");
            ++index;
        }
        System.out.print(sb);
    }

    public void WebcastRoomStatsMessage(byte[] payload) throws InvalidProtocolBufferException {
        RoomStatsMessage roomStats = RoomStatsMessage.parseFrom(payload);
        System.out.println("\u623f\u95f4\u72b6\u6001\u66f4\u65b0 : " + roomStats.getDisplayLong() + " (" + roomStats.getDisplayValue() + ")");
    }

    public DouYinHackLiveRoomWatcher useGzip(boolean useGzip) {
        this.useGzip = useGzip;
        return this;
    }

    public String ttwid() {
        Cookie ttwid = this.browser.getCookie("ttwid");
        return ttwid != null ? ttwid.value() : null;
    }

    public DouYinHackLiveRoomInfo liveRoomInfo() {
        return this.liveRoomInfo;
    }

    public List<String> liveRoomWebStreamURLs() {
        return List.of(this.liveRoomInfo.webStreamURLs());
    }

    private PushFrameAndResponse parseFrame(byte[] bytes) {
        try {
            PushFrame pushFrame = PushFrame.parseFrom(bytes);
            Response response = DouYinHackHelper.getResponse(pushFrame);
            switch (pushFrame.getPayloadType()) {
                case "msg": {
                    for (Message message : response.getMessagesList()) {
                        $.async(() -> this.callHandler(message));
                    }
                    break;
                }
                case "close": {
                    System.out.println("\u5173\u95ed");
                }
            }
            return new PushFrameAndResponse(pushFrame, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

