/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher.impl.kuaishou;

import cool.scx.http.HttpMethod;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.helidon.ScxHttpClientHelper;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.live_room_watcher.AccessToken;
import cool.scx.live_room_watcher.AccessTokenManager;
import cool.scx.live_room_watcher.impl.kuaishou.KuaiShouAccessToken;

class KuaiShouAccessTokenManager
extends AccessTokenManager {
    private final String appID;
    private final String appSecret;

    public KuaiShouAccessTokenManager(String appID, String appSecret) {
        this.appID = appID;
        this.appSecret = appSecret;
    }

    @Override
    protected AccessToken getAccessToken0() {
        ScxHttpClientResponse response = ScxHttpClientHelper.request().method(HttpMethod.POST).uri("https://open.kuaishou.com/oauth2/access_token").send((MultiPart)MultiPart.of().add("app_id", this.appID).add("app_secret", this.appSecret).add("grant_type", "client_credentials"));
        KuaiShouAccessToken accessTokenResult = (KuaiShouAccessToken)response.body().asObject(KuaiShouAccessToken.class);
        if (accessTokenResult.result != 1) {
            throw new IllegalArgumentException(response.body().asString());
        }
        return accessTokenResult;
    }
}

