/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher.impl.kuaishou;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.HttpMethod;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.helidon.ScxHttpClientHelper;
import cool.scx.http.uri.ScxURI;
import cool.scx.live_room_watcher.AbstractLiveRoomWatcher;
import cool.scx.live_room_watcher.impl.kuaishou.KuaiShouAccessTokenManager;
import cool.scx.live_room_watcher.impl.kuaishou.KuaiShouHelper;
import cool.scx.live_room_watcher.impl.kuaishou.KuaiShouMessage;
import cool.scx.live_room_watcher.impl.kuaishou.KuaiShouResponseBody;
import cool.scx.live_room_watcher.impl.kuaishou.KuaiShouTaskStartResult;
import cool.scx.live_room_watcher.impl.kuaishou.message.KuaiShouChat;
import cool.scx.live_room_watcher.impl.kuaishou.message.KuaiShouGift;
import cool.scx.live_room_watcher.impl.kuaishou.message.KuaiShouLike;
import java.io.IOException;
import java.util.HashMap;

public class KuaiShouLiveRoomWatcher
extends AbstractLiveRoomWatcher {
    private final String appID;
    private final String appSecret;
    private final KuaiShouAccessTokenManager accessTokenManager;

    public KuaiShouLiveRoomWatcher(String appID, String appSecret) {
        this.appID = appID;
        this.appSecret = appSecret;
        if (appID == null || appSecret == null) {
            throw new NullPointerException();
        }
        this.accessTokenManager = new KuaiShouAccessTokenManager(appID, appSecret);
    }

    public KuaiShouTaskStartResult taskStart(String roomID, String roundId) throws IOException, InterruptedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roomCode", roomID);
        map.put("timestamp", System.currentTimeMillis());
        map.put("roundId", roundId);
        String sign = KuaiShouHelper.calcSign(map, this.appID, this.appSecret);
        map.put("callBackUrl", "");
        map.put("sign", sign);
        String url = ScxURI.of((String)"https://open.kuaishou.com/openapi/developer/live/data/task/start").addQuery("app_id", new String[]{this.appID}).addQuery("access_token", new String[]{this.accessTokenManager.getAccessToken()}).toString();
        ScxHttpClientResponse response = ScxHttpClientHelper.request().method(HttpMethod.POST).uri(url).send(map);
        String bodyStr = response.body().asString();
        return (KuaiShouTaskStartResult)ObjectUtils.jsonMapper().readValue(bodyStr, KuaiShouTaskStartResult.class);
    }

    public KuaiShouResponseBody taskStop(String roomID, String roundId) throws IOException, InterruptedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roomCode", roomID);
        map.put("timestamp", System.currentTimeMillis());
        map.put("roundId", roundId);
        String sign = KuaiShouHelper.calcSign(map, this.appID, this.appSecret);
        map.put("callBackUrl", "");
        map.put("sign", sign);
        String url = ScxURI.of((String)"https://open.kuaishou.com/openapi/developer/live/data/task/stop").addQuery("app_id", new String[]{this.appID}).addQuery("access_token", new String[]{this.accessTokenManager.getAccessToken()}).toString();
        ScxHttpClientResponse response = ScxHttpClientHelper.request().method(HttpMethod.POST).uri(url).send(map);
        String bodyStr = response.body().asString();
        return (KuaiShouResponseBody)ObjectUtils.jsonMapper().readValue(bodyStr, KuaiShouResponseBody.class);
    }

    public KuaiShouResponseBody taskStatus(String roomID) throws IOException, InterruptedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roomCode", roomID);
        map.put("timestamp", System.currentTimeMillis());
        String sign = KuaiShouHelper.calcSign(map, this.appID, this.appSecret);
        map.put("callBackUrl", "");
        map.put("sign", sign);
        String url = ScxURI.of((String)"https://open.kuaishou.com/openapi/developer/live/data/task/status").addQuery("app_id", new String[]{this.appID}).addQuery("access_token", new String[]{this.accessTokenManager.getAccessToken()}).toString();
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri(url).method(HttpMethod.POST).send(map);
        String bodyStr = response.body().asString();
        return (KuaiShouResponseBody)ObjectUtils.jsonMapper().readValue(bodyStr, KuaiShouResponseBody.class);
    }

    public KuaiShouResponseBody topGift(String roomCode, String[] secGiftIDList) throws IOException, InterruptedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roomCode", roomCode);
        map.put("timestamp", System.currentTimeMillis());
        map.put("giftList", String.join((CharSequence)",", secGiftIDList));
        String sign = KuaiShouHelper.calcSign(map, this.appID, this.appSecret);
        map.put("callBackUrl", "");
        map.put("sign", sign);
        String url = ScxURI.of((String)"https://open.kuaishou.com/openapi/developer/live/interactive/gift/top").addQuery("app_id", new String[]{this.appID}).addQuery("access_token", new String[]{this.accessTokenManager.getAccessToken()}).toString();
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri(url).method(HttpMethod.POST).send(map);
        String bodyStr = response.body().asString();
        return (KuaiShouResponseBody)ObjectUtils.jsonMapper().readValue(bodyStr, KuaiShouResponseBody.class);
    }

    public void callGift(String bodyStr) throws JsonProcessingException {
        KuaiShouGift[] gifts;
        KuaiShouMessage ksMessage = (KuaiShouMessage)ObjectUtils.jsonMapper().readValue(bodyStr, KuaiShouMessage.class);
        for (KuaiShouGift gift : gifts = (KuaiShouGift[])ObjectUtils.convertValue((Object)ksMessage.data.payload, (TypeReference)new TypeReference<KuaiShouGift[]>(this){})) {
            gift.message_id = ksMessage.message_id;
            gift.timestamp = ksMessage.timestamp;
            gift.roomID = ksMessage.data.room_code;
            gift.userInfo.roomID = ksMessage.data.room_code;
            this._callOnGift(gift);
        }
    }

    public void callChat(String bodyStr) throws JsonProcessingException {
        KuaiShouChat[] comments;
        KuaiShouMessage ksMessage = (KuaiShouMessage)ObjectUtils.jsonMapper().readValue(bodyStr, KuaiShouMessage.class);
        for (KuaiShouChat comment : comments = (KuaiShouChat[])ObjectUtils.convertValue((Object)ksMessage.data.payload, (TypeReference)new TypeReference<KuaiShouChat[]>(this){})) {
            comment.message_id = ksMessage.message_id;
            comment.timestamp = ksMessage.timestamp;
            comment.roomID = ksMessage.data.room_code;
            comment.userInfo.roomID = ksMessage.data.room_code;
            this._callOnChat(comment);
        }
    }

    public void callLike(String bodyStr) throws JsonProcessingException {
        KuaiShouLike[] likes;
        KuaiShouMessage ksMessage = (KuaiShouMessage)ObjectUtils.jsonMapper().readValue(bodyStr, KuaiShouMessage.class);
        for (KuaiShouLike like : likes = (KuaiShouLike[])ObjectUtils.convertValue((Object)ksMessage.data.payload, (TypeReference)new TypeReference<KuaiShouLike[]>(this){})) {
            like.message_id = ksMessage.message_id;
            like.timestamp = ksMessage.timestamp;
            like.roomID = ksMessage.data.room_code;
            like.userInfo.roomID = ksMessage.data.room_code;
            this._callOnLike(like);
        }
    }

    public String interactiveStart(String roomID, String roundId, String data) throws IOException, InterruptedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roomCode", roomID);
        map.put("timestamp", System.currentTimeMillis());
        map.put("roundId", roundId);
        map.put("type", "1");
        map.put("data", data);
        String sign = KuaiShouHelper.calcSign(map, this.appID, this.appSecret);
        map.put("callBackUrl", "");
        map.put("sign", sign);
        String url = ScxURI.of((String)"https://open.kuaishou.com/openapi/developer/live/data/interactive/start").addQuery("app_id", new String[]{this.appID}).addQuery("access_token", new String[]{this.accessTokenManager.getAccessToken()}).toString();
        ScxHttpClientResponse response = ScxHttpClientHelper.request().uri(url).method(HttpMethod.POST).send(map);
        return response.body().asString();
    }
}

