/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.live_room_watcher.impl.tiktok_hack;

import com.google.protobuf.ByteString;
import cool.scx.http.ScxWebSocket;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.io.zip.GunzipBuilder;
import cool.scx.live_room_watcher.impl.tiktok_hack.proto_entity.webcast.im.PushFrame;
import cool.scx.live_room_watcher.impl.tiktok_hack.proto_entity.webcast.im.Response;
import cool.scx.live_room_watcher.util.Navigator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

public class TikTokHackHelper {
    public static String initLiveRoomURI(String uri) {
        ScxURIWritable liveRoomURI = ScxURI.of((String)uri).clearQuery();
        if (!"www.tiktok.com".equals(liveRoomURI.host())) {
            throw new IllegalArgumentException("\u4e0d\u662f\u5408\u6cd5 TikTok \u76f4\u64ad\u95f4 url : " + uri);
        }
        return liveRoomURI.toString();
    }

    public static void sendAck(ScxWebSocket webSocket, PushFrame pushFrame, Response response) {
        byte[] ack = PushFrame.newBuilder().setPayloadType("ack").setLogid(pushFrame.getLogid()).setPayload(ByteString.copyFromUtf8((String)response.getInternalExt())).build().toByteArray();
        webSocket.send(ack);
    }

    public static ScxURIWritable getWebSocketURI(String liveRoomID, boolean useGzip) {
        LinkedHashMap<String, Object> internalExtMap = new LinkedHashMap<String, Object>();
        internalExtMap.put("fetch_time", System.currentTimeMillis());
        internalExtMap.put("start_time", System.currentTimeMillis() + 12091L);
        internalExtMap.put("ack_ids", ",,7362851733002865425_c0a,7362851741336914695_c0e,7362851741627042578_c0e,7362851731929221906_c10,7362851744441256705_c10,7362851752600095496_c14,7362851751710018320_c14,7362851750296144656_c14,7362851762753096449_c18,7362851767975594769_c1a,7362851782941117191_c20,7362851782731549457_c22,7362851783590726416_c22,7362851784442628871_c22,7362851789353306896_c24,7362851792784345874_c24,7362851786530835201_c26,7362851792713566983_c26,7362851767849601809_c26");
        internalExtMap.put("flag", "1");
        internalExtMap.put("seq", "1");
        internalExtMap.put("next_cursor", "1714359236756_7363116852240471587_1_1_1714359236473_0");
        internalExtMap.put("wss_info", "0-1714297524165-0-0");
        String internalExt = internalExtMap.entrySet().stream().map(c -> String.valueOf(c.getKey()) + ":" + String.valueOf(c.getValue())).collect(Collectors.joining("|"));
        ScxURIWritable builder = ScxURI.of((String)"/webcast/im/ws_proxy/ws_reuse_supplement/").addQuery("aid", new String[]{"1988"}).addQuery("app_language", new String[]{"zh-Hans"}).addQuery("app_name", new String[]{"tiktok_web"}).addQuery("browser_language", new String[]{Navigator.navigator().language()}).addQuery("browser_name", new String[]{Navigator.navigator().appCodeName()}).addQuery("browser_online", new Object[]{Navigator.navigator().onLine()}).addQuery("browser_platform", new String[]{Navigator.navigator().appCodeName()}).addQuery("browser_version", new String[]{Navigator.navigator().appVersion()}).addQuery("cookie_enabled", new Object[]{Navigator.navigator().cookieEnabled()}).addQuery("cursor", new String[]{"1714298809032_7362857315956243108_1_1_1714298808837_0"}).addQuery("debug", new String[]{"false"}).addQuery("device_platform", new String[]{"web"}).addQuery("heartbeatDuration", new String[]{"0"}).addQuery("host", new String[]{"https://webcast.tiktok.com"}).addQuery("identity", new String[]{"audience"}).addQuery("imprp", new String[]{""}).addQuery("internal_ext", new String[]{internalExt}).addQuery("live_id", new String[]{"12"}).addQuery("room_id", new String[]{liveRoomID}).addQuery("screen_height", new Object[]{691}).addQuery("screen_width", new Object[]{1228}).addQuery("update_version_code", new String[]{"1.3.0"}).addQuery("version_code", new String[]{"270000"}).addQuery("webcast_sdk_version", new String[]{"1.3.0"}).addQuery("tz_name", new String[]{"Asia/Shanghai"}).addQuery("wrss", new String[]{"00000000"});
        if (useGzip) {
            builder.addQuery("compress", new String[]{"gzip"});
        }
        return builder;
    }

    public static Response getResponse(PushFrame pushFrame) throws Exception {
        boolean gzip = pushFrame.getHeadersListList().stream().anyMatch(pushHeader -> "compress_type".equals(pushHeader.getKey()) && "gzip".equals(pushHeader.getValue()));
        byte[] bytes = gzip ? new GunzipBuilder((InputStream)new ByteArrayInputStream(pushFrame.getPayload().toByteArray())).readAllBytes() : pushFrame.getPayload().toByteArray();
        return Response.parseFrom(bytes);
    }
}

