/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.ScxHttpBody;
import cool.scx.http.ScxHttpHeaders;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScxHttpBodyImpl
implements ScxHttpBody {
    private final AtomicBoolean alreadyRead;
    private final InputStream inputStream;
    private final ScxHttpHeaders headers;

    public ScxHttpBodyImpl(InputStream inputStream, ScxHttpHeaders headers, int maxBufferSize) {
        if (maxBufferSize > 0) {
            this.inputStream = new BufferedInputStream(inputStream, maxBufferSize);
            this.inputStream.mark(0);
        } else {
            this.inputStream = inputStream;
        }
        this.headers = headers;
        this.alreadyRead = new AtomicBoolean(false);
    }

    @Override
    public ScxHttpHeaders headers() {
        return this.headers;
    }

    @Override
    public InputStream inputStream() {
        if (this.inputStream instanceof BufferedInputStream) {
            try {
                this.inputStream.reset();
                return this.inputStream;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.alreadyRead.get()) {
            throw new IllegalStateException("\u975e\u7f13\u51b2\u6a21\u5f0f\u7684 Body \u53ea\u80fd\u8bfb\u53d6\u4e00\u6b21 !!!");
        }
        this.alreadyRead.set(true);
        return this.inputStream;
    }

    public String toString() {
        return this.asString();
    }
}

