/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.range;

import java.util.ArrayList;
import java.util.List;

public record Range(Long start, Long end) {
    public static List<Range> parseRange(String rangeHeader) {
        String[] parts;
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (rangeHeader == null || !rangeHeader.startsWith("bytes=")) {
            return ranges;
        }
        for (String part : parts = rangeHeader.substring(6).split(",")) {
            String[] range = part.split("-", 2);
            if (range.length != 2) continue;
            String startStr = range[0];
            String endStr = range[1];
            Long start = !startStr.isEmpty() ? Long.valueOf(Long.parseLong(startStr)) : null;
            Long end = !endStr.isEmpty() ? Long.valueOf(Long.parseLong(endStr)) : null;
            ranges.add(new Range(start, end));
        }
        return ranges;
    }

    public long getStart() {
        return this.start != null ? this.start : 0L;
    }

    public long getEnd(long fileLength) {
        return this.end != null ? Long.min(this.end, fileLength - 1L) : fileLength - 1L;
    }
}

