/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing;

import cool.scx.http.ScxServerWebSocket;
import cool.scx.http.routing.WebSocketRoute;
import cool.scx.http.routing.WebSocketRoutingContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class WebSocketRouter
implements Consumer<ScxServerWebSocket> {
    private static final Comparator<WebSocketRoute> ROUTE_COMPARATOR = (o1, o2) -> {
        int compare = Integer.compare(o1.order(), o2.order());
        if (compare == 0) {
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
        return compare;
    };
    final TreeSet<WebSocketRoute> routes = new TreeSet<WebSocketRoute>(ROUTE_COMPARATOR);
    BiConsumer<Throwable, WebSocketRoutingContext> errorHandler;

    public WebSocketRouter addRoute(WebSocketRoute route) {
        this.routes.add(route);
        return this;
    }

    public List<WebSocketRoute> getRoutes() {
        return new ArrayList<WebSocketRoute>(this.routes);
    }

    @Override
    public void accept(ScxServerWebSocket scxServerWebSocket) {
        new WebSocketRoutingContext(this, scxServerWebSocket).next();
    }

    public WebSocketRouter errorHandler(BiConsumer<Throwable, WebSocketRoutingContext> handler) {
        this.errorHandler = handler;
        return this;
    }
}

