/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing;

import cool.scx.http.Parameters;
import cool.scx.http.ScxServerWebSocket;
import cool.scx.http.exception.NotFoundException;
import cool.scx.http.routing.PathMatcher;
import cool.scx.http.routing.WebSocketRoute;
import cool.scx.http.routing.WebSocketRouter;
import java.util.Iterator;

public class WebSocketRoutingContext {
    private final WebSocketRouter router;
    private final ScxServerWebSocket webSocket;
    private final Iterator<WebSocketRoute> iter;
    private Parameters<String, String> nowPathParams;

    public WebSocketRoutingContext(WebSocketRouter router, ScxServerWebSocket webSocket) {
        this.router = router;
        this.webSocket = webSocket;
        this.iter = router.routes.iterator();
    }

    public ScxServerWebSocket webSocket() {
        return this.webSocket;
    }

    public final void next() {
        try {
            this.tryNext();
        }
        catch (Throwable e) {
            this.router.errorHandler.accept(e, this);
        }
    }

    void tryNext() throws Throwable {
        NotFoundException e = new NotFoundException();
        while (this.iter.hasNext()) {
            WebSocketRoute routeState = this.iter.next();
            PathMatcher.MatchResult pathMatchResult = routeState.pathMatcher().matches(this.webSocket.path());
            this.nowPathParams = pathMatchResult.pathParams();
            if (!pathMatchResult.accepted()) continue;
            routeState.handler().accept(this);
            return;
        }
        throw e;
    }

    public Parameters<String, String> pathParams() {
        return this.nowPathParams;
    }
}

