/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing.handler;

import cool.scx.http.FileFormat;
import cool.scx.http.HttpFieldName;
import cool.scx.http.HttpStatusCode;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.content_type.ContentTypeWritable;
import cool.scx.http.exception.NotFoundException;
import cool.scx.http.range.Range;
import cool.scx.http.routing.RoutingContext;
import cool.scx.io.IOHelper;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class StaticHelper {
    public static void sendStatic(Path path, RoutingContext context) {
        ScxHttpServerRequest request = context.request();
        ScxHttpServerResponse response = context.response();
        boolean notExists = Files.notExists(path, new LinkOption[0]);
        if (notExists) {
            throw new NotFoundException();
        }
        long fileLength = IOHelper.getFileSize((Path)path);
        response.headers().set(HttpFieldName.ACCEPT_RANGES, "bytes");
        String rangeStr = request.getHeader("Range");
        if (response.contentType() == null) {
            ContentTypeWritable contentType = StaticHelper.getMediaTypeByFile(path);
            response.contentType(contentType);
        }
        if (rangeStr == null) {
            response.send(path);
            return;
        }
        List<Range> ranges = Range.parseRange(rangeStr);
        if (ranges.size() == 1) {
            Range range = ranges.get(0);
            long start = range.getStart();
            long end = range.getEnd(fileLength);
            long length = end - start + 1L;
            response.status(HttpStatusCode.PARTIAL_CONTENT);
            response.setHeader(HttpFieldName.CONTENT_RANGE, "bytes " + start + "-" + end + "/" + fileLength);
            response.contentLength(length);
            response.send(path, start, length);
        } else {
            response.send(path);
        }
    }

    public static ContentTypeWritable getMediaTypeByFile(Path path) {
        FileFormat fileFormat = FileFormat.findByFileName(path.getFileName().toString());
        if (fileFormat == null) {
            fileFormat = FileFormat.BIN;
        }
        MediaType mediaType = fileFormat.mediaType();
        ContentTypeWritable contentType = ContentType.of(mediaType);
        if (mediaType == MediaType.TEXT_PLAIN || mediaType == MediaType.TEXT_HTML || mediaType == MediaType.APPLICATION_XML || mediaType == MediaType.APPLICATION_JSON) {
            contentType.charset(StandardCharsets.UTF_8);
        }
        return contentType;
    }
}

