/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.uri;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;

public class URIEncoder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final boolean[] DONT_NEED_ENCODING_URI = URIEncoder.initDontNeedEncoding("!", "#", "$", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "=", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "~");
    private static final boolean[] DONT_NEED_ENCODING_URI_COMPONENT = URIEncoder.initDontNeedEncoding("!", "'", "(", ")", "*", "-", ".", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "~");

    private static boolean[] initDontNeedEncoding(String ... c) {
        boolean[] table = new boolean[128];
        for (String s : c) {
            int i = s.codePointAt(0);
            table[i] = true;
        }
        return table;
    }

    private static String encode(String str, boolean[] dontNeedEncoding) {
        int[] codePoints;
        StringBuilder sb = new StringBuilder();
        for (int codePoint : codePoints = str.codePoints().toArray()) {
            if (codePoint < 128 && dontNeedEncoding[codePoint]) {
                sb.appendCodePoint(codePoint);
                continue;
            }
            URIEncoder.appendUTF8EncodedCharacter(sb, codePoint);
        }
        return sb.toString();
    }

    public static String encodeURI(String uri) {
        return URIEncoder.encode(uri, DONT_NEED_ENCODING_URI);
    }

    public static String encodeURIComponent(String uriComponent) {
        return URIEncoder.encode(uriComponent, DONT_NEED_ENCODING_URI_COMPONENT);
    }

    private static void appendUTF8EncodedCharacter(StringBuilder sb, int codePoint) {
        CharBuffer chars = CharBuffer.wrap(Character.toChars(codePoint));
        ByteBuffer bytes = StandardCharsets.UTF_8.encode(chars);
        while (bytes.hasRemaining()) {
            URIEncoder.appendEscape(sb, bytes.get() & 0xFF);
        }
    }

    private static void appendEscape(StringBuilder appender, int b) {
        appender.append('%');
        appender.append(HEX_DIGITS[b >> 4]);
        appender.append(HEX_DIGITS[b & 0xF]);
    }
}

