/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.LinkedDataReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.function.Supplier;

public class InputStreamDataSupplier
implements Supplier<LinkedDataReader.Node> {
    private final InputStream inputStream;
    private final int bufferLength;
    private final boolean compress;

    public InputStreamDataSupplier(InputStream inputStream) {
        this(inputStream, 8192, false);
    }

    public InputStreamDataSupplier(InputStream inputStream, boolean compress) {
        this(inputStream, 8192, compress);
    }

    public InputStreamDataSupplier(InputStream inputStream, int bufferLength) {
        this(inputStream, bufferLength, false);
    }

    public InputStreamDataSupplier(InputStream inputStream, int bufferLength, boolean compress) {
        this.inputStream = inputStream;
        this.bufferLength = bufferLength;
        this.compress = compress;
    }

    @Override
    public LinkedDataReader.Node get() {
        try {
            byte[] bytes = new byte[this.bufferLength];
            int i = this.inputStream.read(bytes);
            if (i == -1) {
                return null;
            }
            if (i == this.bufferLength) {
                return new LinkedDataReader.Node(bytes);
            }
            if (this.compress) {
                byte[] data = new byte[i];
                System.arraycopy(bytes, 0, data, 0, i);
                return new LinkedDataReader.Node(data);
            }
            return new LinkedDataReader.Node(bytes, 0, i);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

