/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public final class ProgressiveJPEGBuilder {
    public static ImageWriter getImageWriter(String formatName) {
        Iterator<ImageWriter> writerIterator = ImageIO.getImageWritersByFormatName(formatName.trim().toLowerCase());
        ImageWriter writer = writerIterator.next();
        if (writer == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u683c\u5f0f\u7684 ImageWriter , formatName : " + formatName);
        }
        return writer;
    }

    public static byte[] toProgressiveJPEG(InputStream inputStream) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ProgressiveJPEGBuilder.toProgressiveJPEG(inputStream, b);
        return b.toByteArray();
    }

    public static void toProgressiveJPEG(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedImage sourceImage = ImageIO.read(inputStream);
        ImageWriter jpegWriter = ProgressiveJPEGBuilder.getImageWriter("jpeg");
        ImageWriteParam writeParam = jpegWriter.getDefaultWriteParam();
        writeParam.setProgressiveMode(1);
        try (MemoryCacheImageOutputStream m = new MemoryCacheImageOutputStream(outputStream);){
            jpegWriter.setOutput(m);
            jpegWriter.write(null, new IIOImage(sourceImage, null, null), writeParam);
            jpegWriter.dispose();
        }
    }
}

