/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.zip;

import cool.scx.common.util.StringUtils;
import cool.scx.common.util.URIBuilder;
import cool.scx.io.zip.ZipBuilderItem;
import cool.scx.io.zip.ZipOptions;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class PathZipBuilderItem
extends ZipBuilderItem {
    private final Path path;

    public PathZipBuilderItem(String zipPath, Path path, ZipOptions zipOptions) throws IOException {
        super(PathZipBuilderItem.getZipPathByPath(zipPath, path, zipOptions), Files.newInputStream(path, new OpenOption[0]));
        this.path = path;
    }

    private static String getZipPathByPath(String zipPath, Path path, ZipOptions zipOptions) {
        String fileName = path.getFileName().toString();
        String normalizeZipPath = URIBuilder.trimSlash((String)URIBuilder.normalize((String)zipPath));
        if (Files.isDirectory(path, new LinkOption[0])) {
            String dirName = zipOptions.includeRoot() ? fileName : "";
            String rootPath = URIBuilder.join((String[])new String[]{normalizeZipPath, dirName});
            return StringUtils.isEmpty((String)rootPath) ? rootPath : URIBuilder.addSlashEnd((String)rootPath);
        }
        if (StringUtils.isEmpty((String)normalizeZipPath)) {
            return fileName;
        }
        if (zipOptions.useOriginalFileName()) {
            return URIBuilder.join((String[])new String[]{normalizeZipPath, fileName});
        }
        return normalizeZipPath;
    }

    @Override
    public void writeToZipOutputStream(ZipOutputStream zos) throws IOException {
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            this.writeToZipOutputStreamByDirectory(zos);
        } else {
            super.writeToZipOutputStream(zos);
        }
    }

    private void writeToZipOutputStreamByDirectory(final ZipOutputStream zos) throws IOException {
        Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
            final /* synthetic */ PathZipBuilderItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String finalPath = this.this$0.zipPath + String.valueOf(this.this$0.path.relativize(file));
                if (attrs.isDirectory()) {
                    zos.putNextEntry(new ZipEntry(finalPath + "/"));
                } else {
                    zos.putNextEntry(new ZipEntry(finalPath));
                    Files.copy(file, zos);
                }
                zos.closeEntry();
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

