/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.zip;

import cool.scx.common.util.FileUtils;
import cool.scx.common.util.URIBuilder;
import cool.scx.io.zip.ZipOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class UnZipBuilder {
    private final InputStream source;
    private Path path = null;

    public UnZipBuilder(InputStream source) {
        this.source = source;
    }

    public UnZipBuilder(Path path) throws IOException {
        this(Files.newInputStream(path, new OpenOption[0]));
        this.path = path;
    }

    public UnZipBuilder(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public void toFile(Path outputPath, ZipOptions zipOptions) throws IOException {
        Files.createDirectories(outputPath, new FileAttribute[0]);
        String rootPath = this.getRootPath(zipOptions);
        try (ZipInputStream zis = new ZipInputStream(this.source, zipOptions.charset());){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path unzipFilePath = outputPath.resolve(rootPath + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(unzipFilePath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(unzipFilePath.getParent(), new FileAttribute[0]);
                    Files.copy(zis, unzipFilePath, StandardCopyOption.REPLACE_EXISTING);
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
    }

    public void toFile(Path outputPath) throws IOException {
        this.toFile(outputPath, new ZipOptions());
    }

    private String getRootPath(ZipOptions zipOptions) {
        if (zipOptions.includeRoot() && this.path != null) {
            String fileName = this.path.getFileName().toString();
            String fileNameWithoutExtension = FileUtils.getFileNameWithoutExtension((String)fileName);
            return URIBuilder.addSlashEnd((String)fileNameWithoutExtension);
        }
        return "";
    }
}

