/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ReflectFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public final class FieldInfo {
    private final Field field;
    private final ClassInfo classInfo;
    private final String name;
    private final AccessModifier accessModifier;
    private final JavaType type;
    private final Annotation[] annotations;

    FieldInfo(Field field, ClassInfo classInfo) {
        this.field = field;
        this.classInfo = classInfo;
        this.name = ReflectFactory._findName(this);
        this.accessModifier = ReflectFactory._findAccessModifier(this);
        this.type = ReflectFactory._findType(this);
        this.annotations = ReflectFactory._findAnnotations(this);
    }

    public Field field() {
        return this.field;
    }

    public ClassInfo classInfo() {
        return this.classInfo;
    }

    public String name() {
        return this.name;
    }

    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    public JavaType type() {
        return this.type;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this.field.getAnnotationsByType(annotationClass);
    }

    public void setAccessible(boolean flag) {
        this.field.setAccessible(flag);
    }

    public void set(Object obj, Object value) throws IllegalAccessException {
        this.field.set(obj, value);
    }

    public Object get(Object obj) throws IllegalAccessException {
        return this.field.get(obj);
    }
}

