/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.espresso.presutec.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import coop.intergal.vaadin.rest.utils.DataService;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;

public class JSonClient {
    private static CloseableHttpClient client = HttpClientBuilder.create().build();
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
    private static Boolean SHOW_LOGS = true;
    private static Boolean SHOW_LOGS_DETAIL = false;
    static String BASE_URL = "http://localhost:8090/call-center-rest-api/rest/default/ccAF/v1/";
    protected static String MY_API_KEY = "xJUmSI6bZvxpgjfGc5Hf";
    protected static String API_KEY = "Espresso " + MY_API_KEY + ":1";
    private static final Header API_KEY_HEADER = new BasicHeader("Authorization", API_KEY);
    private static Hashtable<String, JsonNode> jsonCaches = new Hashtable();
    private static Header apiKeyHeader;
    private static String baseURL;
    private static String kPreConfParam;
    private static String tableNameRoot;
    static Hashtable<String, String> ht;
    static Hashtable<String, Hashtable<String, String>> resourceHtPK;
    static Hashtable<String, JsonNode> parents;
    static Hashtable<String, Hashtable<String, JsonNode>> parentsResource;
    private static String resourceTableName;
    private static String kbaseURL;
    private static Hashtable<String, String> keepIdent;
    private JsonNode keepJson;

    public static void main(String[] args) throws Exception {
        JSonClient.setConfigEspreso(null);
        if (baseURL == null) {
            baseURL = BASE_URL;
            apiKeyHeader = API_KEY_HEADER;
        }
        System.setProperty("javax.net.ssl.trustStore", "src/main/resources/mykeystore");
        JSonClient.printLog("\n\n------ Retrieve all customers using BASE_URL: " + baseURL);
        JsonNode customerList = JSonClient.get("Region", null, true, null);
        for (JsonNode eachCustomer : customerList) {
            JSonClient.printLog("nome:" + eachCustomer.get("nameEntity").asText());
            JSonClient.printLog("   IdPersoa:" + eachCustomer.get("idEntity").asText());
        }
        JSonClient.printLog("\n\n------ Insert a new customer");
        ObjectNode newCustomerinfo = new ObjectNode(nodeFactory);
        newCustomerinfo.put("nameEntity", "NewCustomer");
        JsonNode postResult = JSonClient.post("Entity", (JsonNode)newCustomerinfo, null);
        if (postResult.get("statusCode").intValue() != 201) {
            throw new RuntimeException("Unable to insert: " + postResult);
        }
        JsonNode postTxSummary = postResult.get("txsummary");
        for (JsonNode node : postTxSummary) {
            JSonClient.printLog("Transaction summary for post: " + node);
        }
        ObjectNode insertedNode = (ObjectNode)postTxSummary.get(0);
        JSonClient.printLog("\n\n------ Update the new customer");
        insertedNode.put("keyEntity", "modificado");
        JsonNode putResult = JSonClient.put("Entity", (JsonNode)insertedNode, null);
        if (putResult.get("statusCode").intValue() != 200) {
            throw new RuntimeException("Unable to update: " + putResult);
        }
        JsonNode putTxSummary = putResult.get("txsummary");
        for (JsonNode node : putTxSummary) {
            JSonClient.printLog("Transaction summary for put: " + node);
        }
        ObjectNode updatedNode = (ObjectNode)putTxSummary.get(0);
        JSonClient.printLog("\n\n------ Delete the new customer");
        JsonNode deleteResult = JSonClient.delete((JsonNode)updatedNode, null);
        if (deleteResult.get("statusCode").intValue() != 200) {
            throw new RuntimeException("Unable to delete: " + deleteResult);
        }
        JsonNode deleteTxSummary = deleteResult.get("txsummary");
        for (JsonNode node : deleteTxSummary) {
            JSonClient.printLog("Transaction summary for delete: " + node);
        }
        JSonClient.printLog("\n------ Test is complete");
    }

    private static void printLog(String string) {
        if (SHOW_LOGS.booleanValue() && !string.startsWith("#line")) {
            System.out.println(new Date().toString() + " JSonClient.printLog()-->" + string);
        } else if (SHOW_LOGS.booleanValue() && SHOW_LOGS_DETAIL.booleanValue()) {
            System.out.println(new Date().toString() + " JSonClient.printLog()-->" + string);
        }
    }

    public static JsonNode get(String resource, String filter, boolean useCache, String preConfParam) throws Exception {
        return JSonClient.get(resource, filter, useCache, preConfParam, null);
    }

    public static JsonNode get(String resource, String filter, boolean useCache, String preConfParam, String pagesize) throws Exception {
        int max;
        JsonNode keepJson;
        filter = JSonClient.changeIfIsDerbyDBFromLAC(resource, filter);
        if (pagesize == null) {
            pagesize = "200";
        }
        JSonClient.printLog("1 preConfParam " + preConfParam + " kPreConfParam " + kPreConfParam);
        JSonClient.calculateBaseURL(preConfParam);
        JSonClient.printLog("2 preConfParam " + preConfParam + " kPreConfParam " + kPreConfParam);
        String url = baseURL;
        if (filter != null && filter.startsWith("#PK#")) {
            url = url + resource + "/" + filter.substring(4);
        } else {
            url = url + resource + "?pagesize=" + pagesize;
            if (resource.indexOf("?") > 0) {
                url = baseURL + resource + "&pagesize=" + pagesize;
            }
            if (filter != null && filter.startsWith("order=")) {
                url = url + "&" + filter;
            } else if (filter != null && filter.length() > 0) {
                url = url + "&filter=" + filter;
            }
        }
        JSonClient.printLog("tengo en url : (JsonNode get(String resource...)" + url);
        if (useCache && (keepJson = JSonClient.getJsonCache(url)) != null) {
            JSonClient.printLog("the URL " + url + " with the resource " + resource + " and filter " + filter + " is return form cache ");
            return keepJson;
        }
        HttpGet get = new HttpGet(url);
        get.addHeader(apiKeyHeader);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        JsonNode parResponse = JSonClient.parseResponse((HttpResponse)response);
        if (useCache) {
            jsonCaches.put(url, parResponse);
        }
        if ((max = parResponse.asText().length()) > 50) {
            max = 50;
        }
        JSonClient.printLog("Response : max:" + max + " " + parResponse.asText().substring(0, max) + ".............");
        return parResponse;
    }

    public static InputStream getStream(String url, String preConfParam) throws Exception {
        CloseableHttpClient clientStream = HttpClientBuilder.create().build();
        JSonClient.printLog(" preConfParam " + preConfParam + " kPreConfParam " + kPreConfParam);
        if (preConfParam == null) {
            if (baseURL == null) {
                JSonClient.setConfigEspreso(null);
            }
        } else if (baseURL == null | preConfParam.equals(kPreConfParam)) {
            JSonClient.setConfigEspreso(preConfParam);
            if (baseURL == null) {
                baseURL = BASE_URL;
                apiKeyHeader = API_KEY_HEADER;
            }
        } else if (!preConfParam.equals(kPreConfParam)) {
            JSonClient.setConfigEspreso(preConfParam);
            if (baseURL == null) {
                baseURL = BASE_URL;
                apiKeyHeader = API_KEY_HEADER;
            }
        }
        if (!url.startsWith("http")) {
            url = baseURL + url;
        }
        JSonClient.printLog("tengo en url  (JsonNode get(String url,.....) : " + url);
        HttpGet get = new HttpGet(url);
        get.addHeader(apiKeyHeader);
        CloseableHttpResponse response = clientStream.execute((HttpUriRequest)get);
        InputStream inputStream = response.getEntity().getContent();
        return inputStream;
    }

    private static String changeIfIsDerbyDBFromLAC(String resourceName, String filter) {
        if (filter != null && filter.length() > 0 && resourceName.indexOf("resource") > 0) {
            int idxFirstEqual = filter.indexOf("=");
            int idxFirstLike = filter.indexOf("%20like");
            int idxFirstApostrofe = filter.indexOf("'");
            filter = JSonClient.containsDigits(filter.substring(idxFirstApostrofe + 1, idxFirstApostrofe + 2)) ? filter.replaceAll("'", "") : filter.replaceAll("'", "%27");
            filter = idxFirstEqual > 0 ? "%22" + filter.substring(0, idxFirstEqual) + "%22" + filter.substring(idxFirstEqual) : "%22" + filter.substring(0, idxFirstLike) + "%22" + filter.substring(idxFirstLike);
        }
        return filter;
    }

    private static boolean containsDigits(String str) {
        Pattern patt = Pattern.compile("\\d");
        Matcher m = patt.matcher(str);
        return m.matches();
    }

    private static void setConfigEspreso(String preConfParam) {
        kPreConfParam = preConfParam;
        Properties prop = new Properties();
        try {
            InputStream is = JSonClient.class.getResourceAsStream("/espresso.properties");
            JSonClient.printLog(".....IS......" + is);
            preConfParam = preConfParam == null ? "" : preConfParam + "_";
            if (is != null) {
                prop.load(is);
                String hostName = InetAddress.getLocalHost().getHostName();
                JSonClient.printLog("host name: " + hostName + " preConfParam " + preConfParam);
                baseURL = prop.getProperty(preConfParam + "BASE_URL");
                apiKeyHeader = new BasicHeader("Authorization", prop.getProperty(preConfParam + "API_KEY"));
                if (hostName.indexOf(".local") == -1) {
                    String urlHost = prop.getProperty(hostName);
                    baseURL = urlHost + baseURL.substring(baseURL.indexOf("/rest/"));
                }
                JSonClient.printLog("host name: " + hostName + " baseUrl: " + baseURL);
            }
        }
        catch (FileNotFoundException e) {
            JSonClient.printLog("Error, El archivo no exite");
        }
        catch (IOException e) {
            JSonClient.printLog("Error, No se puede leer el archivo");
        }
    }

    public static String getBaseURL() {
        return baseURL;
    }

    private static JsonNode getJsonCache(String url) {
        if (jsonCaches.get(url) != null) {
            return jsonCaches.get(url);
        }
        return null;
    }

    public static JsonNode get(String url, String preConfParam) throws Exception {
        JSonClient.printLog(" preConfParam " + preConfParam + " kPreConfParam " + kPreConfParam);
        if (preConfParam == null) {
            if (baseURL == null) {
                JSonClient.setConfigEspreso(null);
            }
        } else if (baseURL == null | preConfParam.equals(kPreConfParam)) {
            JSonClient.setConfigEspreso(preConfParam);
            if (baseURL == null) {
                baseURL = BASE_URL;
                apiKeyHeader = API_KEY_HEADER;
            }
        } else if (!preConfParam.equals(kPreConfParam)) {
            JSonClient.setConfigEspreso(preConfParam);
            if (baseURL == null) {
                baseURL = BASE_URL;
                apiKeyHeader = API_KEY_HEADER;
            }
        }
        if (!url.startsWith("http")) {
            url = baseURL + url;
        }
        JSonClient.printLog("tengo en url  (JsonNode get(String url,.....) : " + url);
        HttpGet get = new HttpGet(url);
        get.addHeader(apiKeyHeader);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        JsonNode parResponse = JSonClient.parseResponse((HttpResponse)response);
        JSonClient.printLog("Response : " + parResponse);
        return parResponse;
    }

    public static JsonNode put(String resource, JsonNode object, String preConfParam) throws Exception {
        JSonClient.calculateBaseURL(preConfParam);
        HttpPut put = new HttpPut(baseURL + resource);
        put.addHeader(apiKeyHeader);
        StringEntity entity = new StringEntity(object.toString(), "UTF-8");
        entity.setContentType("application/json;charset=UTF-8");
        put.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)put);
        JsonNode parResponse = JSonClient.parseResponse((HttpResponse)response);
        return parResponse;
    }

    private static void calculateBaseURL(String preConfParam) {
        System.out.println("JSonClient.calculateBaseURL() " + preConfParam);
        if (preConfParam == null) {
            if (baseURL == null) {
                JSonClient.setConfigEspreso(null);
            }
        } else if (baseURL == null || !kPreConfParam.equals(preConfParam) || !baseURL.equals(kbaseURL)) {
            JSonClient.setConfigEspreso(preConfParam);
            if (baseURL == null) {
                baseURL = BASE_URL;
                apiKeyHeader = API_KEY_HEADER;
            } else {
                kbaseURL = baseURL;
            }
        }
    }

    public static JsonNode post(String resource, JsonNode object, String preConfParam) throws Exception {
        JSonClient.calculateBaseURL(preConfParam);
        HttpPost post = new HttpPost(baseURL + resource);
        post.addHeader(apiKeyHeader);
        if (object != null) {
            StringEntity entity = new StringEntity(object.toString(), "UTF-8");
            entity.setContentType("application/json;charset=UTF-8");
            post.setEntity((HttpEntity)entity);
            JSonClient.printLog(post + "POST..... " + post.toString());
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        JsonNode parResponse = JSonClient.parseResponse((HttpResponse)response);
        return parResponse;
    }

    public static JsonNode delete(JsonNode object, String preConfParam) throws Exception {
        JSonClient.calculateBaseURL(preConfParam);
        String objectUrl = object.get("@metadata").get("href").asText();
        String checksum = object.get("@metadata").get("checksum").asText();
        HttpDelete delete = new HttpDelete(objectUrl + "?checksum=" + checksum);
        delete.addHeader(apiKeyHeader);
        CloseableHttpResponse response = client.execute((HttpUriRequest)delete);
        JsonNode parResponse = JSonClient.parseResponse((HttpResponse)response);
        return parResponse;
    }

    public static JsonNode delete(String resource, String preConfParam) throws Exception {
        JSonClient.calculateBaseURL(preConfParam);
        HttpDelete delete = new HttpDelete(baseURL + resource);
        delete.addHeader(apiKeyHeader);
        JSonClient.printLog(delete + "POST..... " + delete.toString());
        CloseableHttpResponse response = client.execute((HttpUriRequest)delete);
        JsonNode parResponse = JSonClient.parseResponse((HttpResponse)response);
        return parResponse;
    }

    private static JsonNode parseResponse(HttpResponse response) throws Exception {
        InputStreamReader inStr = new InputStreamReader(response.getEntity().getContent(), "utf-8");
        BufferedReader rd = new BufferedReader(inStr);
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = rd.readLine()) != null) {
            JSonClient.printLog("#line " + line);
            sb.append(line);
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode inData = mapper.readTree(sb.toString());
        return inData;
    }

    public static String getPKTable(String table, String preConfParam) {
        JsonNode resource = null;
        try {
            resource = JSonClient.get("@tables/" + JSonClient.cleanNoDBPrefix(table), null, true, preConfParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resource.get("errorCode") == null) {
            JsonNode pKeyColumns = resource.get("primaryKeyColumns");
            String keys = "";
            int i = 0;
            for (JsonNode eachRow : pKeyColumns) {
                String keyName = eachRow.asText();
                if (++i == 1) {
                    keys = keyName;
                    continue;
                }
                keys = keys + ";" + keyName;
            }
            return keys;
        }
        return null;
    }

    private static String cleanNoDBPrefix(String table) {
        if (table != null && table.startsWith("CHAIN:")) {
            return table.substring(6);
        }
        return table;
    }

    public static String getFKFromTable(String table, String childTableName, String preConfParam) {
        JsonNode resource = null;
        try {
            resource = JSonClient.get("@tables/" + JSonClient.cleanNoDBPrefix(table), null, true, preConfParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resource.get("errorCode") == null) {
            JsonNode pKeyColumns = resource.get("children");
            String keys = "";
            int i = 0;
            for (JsonNode eachRow : pKeyColumns) {
                String childTable = eachRow.get("child_table").asText();
                int idxColon = childTable.indexOf(":");
                if (!(childTable = childTable.substring(idxColon + 1)).equals(childTableName)) continue;
                JsonNode childKeyColumns = eachRow.get("child_columns");
                for (JsonNode eachChlidKey : childKeyColumns) {
                    String keyName = eachChlidKey.asText();
                    if (++i == 1) {
                        keys = keyName;
                        continue;
                    }
                    keys = keys + ";" + keyName;
                }
            }
            return keys;
        }
        return null;
    }

    public static String getDataType(String resourceName, String field, String childName, boolean cache, String preConfParam) throws Exception {
        String type = "";
        if (resourceName == null && childName.startsWith("List-")) {
            resourceName = childName.substring(5);
        }
        if (field.startsWith("FK-")) {
            String tName = field.substring(3);
            while (tName.indexOf("FK-") != -1) {
                tName = tName.substring(tName.indexOf("FK-") + 3);
            }
            int line2 = tName.indexOf("-");
            String fName = tName.substring(line2 + 1);
            tName = tName.substring(0, line2);
            type = JSonClient.getDataTypeFromTable(tName, fName, cache, preConfParam);
            if (type == null) {
                type = JSonClient.getDataTypeFromTable(tName, fName, false, preConfParam);
            }
        } else {
            type = JSonClient.getDataTypeFromTable(JSonClient.cleanNoDBPrefix(resourceName), field, cache, preConfParam);
        }
        if (type != null) {
            return type;
        }
        return JSonClient.getDataTypeFromResource(resourceName, field, childName, cache, preConfParam);
    }

    private static String getDataTypeFromResource(String resourceName, String field, String childName, Boolean cache, String preConfParam) throws Exception {
        JsonNode resource = null;
        String ident = null;
        String tableName = null;
        int posPointForSubR = resourceName.indexOf(".");
        String subResourceName = null;
        if (posPointForSubR > -1) {
            subResourceName = resourceName.substring(posPointForSubR + 1);
            resourceName = resourceName.substring(0, posPointForSubR);
        }
        ident = JSonClient.getIdentOfResource(resourceName, cache, preConfParam);
        try {
            if (ident != null) {
                resource = JSonClient.get("@resources/" + ident, null, cache, preConfParam);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resource != null && resource.size() > 0 && (childName == null || childName.isEmpty())) {
            tableNameRoot = tableName = resource.get("table_name").asText();
        } else if (resource != null && resource.size() > 0) {
            JsonNode subResourceTable = JSonClient.getSubResourceTable(resource, childName);
            if (subResourceTable != null) {
                tableName = subResourceTable.get("table_name").asText();
            } else {
                resource = JSonClient.get("@resources/" + ident, null, false, preConfParam);
                subResourceTable = JSonClient.getSubResourceTable(resource, childName);
                if (subResourceTable != null) {
                    tableName = subResourceTable.get("table_name").asText();
                }
            }
        }
        return JSonClient.getDataTypeFromTable(tableName, field, cache, preConfParam);
    }

    public static String getIdentOfResource(String resourceName, boolean cache, String preConfParam) {
        String ident = null;
        if (keepIdent != null && keepIdent.get(resourceName) != null) {
            ident = keepIdent.get(resourceName);
            return ident;
        }
        JsonNode resource = null;
        try {
            resource = JSonClient.get("@resources", null, cache, preConfParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resource == null || resource.get("statusCode") != null) {
            return null;
        }
        for (JsonNode eachRow : resource) {
            String name = eachRow.get("name").asText();
            String ident1 = eachRow.get("ident").asText();
            if (!name.equals(resourceName)) continue;
            ident = eachRow.get("ident").asText();
            keepIdent.put(resourceName, ident);
            return ident;
        }
        return null;
    }

    private static JsonNode getSubResourceTable(JsonNode resource, String childName) {
        int idxAfterLastPoint = childName.lastIndexOf(".") + 1;
        childName = childName.substring(idxAfterLastPoint);
        JsonNode subResources = resource.get("subresources");
        if (subResources != null) {
            for (JsonNode eachRow : subResources) {
                String resourceName = eachRow.get("name").asText();
                if (ht.get(childName) == null) {
                    ht.put(childName, eachRow.get("join_condition").asText());
                }
                if (resourceName.equals(childName)) {
                    return eachRow;
                }
                JsonNode subResources1 = eachRow.get("subresources");
                if (subResources1 == null) continue;
                if (ht.get(childName) == null) {
                    ht.put(childName, eachRow.get("join_condition").asText());
                }
                for (JsonNode eachRow1 : subResources1) {
                    String resourceName1 = eachRow1.get("name").asText();
                    if (resourceName1.equals(childName)) {
                        return eachRow1;
                    }
                    JsonNode subResources2 = eachRow1.get("subresources");
                    if (subResources2 == null) continue;
                    if (ht.get(childName) == null) {
                        ht.put(childName, eachRow.get("join_condition").asText());
                    }
                    for (JsonNode eachRow2 : subResources2) {
                        String resourceName2 = eachRow2.get("name").asText();
                        if (resourceName2.equals(childName)) {
                            return eachRow2;
                        }
                        JsonNode subResources3 = eachRow2.get("subresources");
                        if (subResources3 == null) continue;
                        if (ht.get(childName) == null) {
                            ht.put(childName, eachRow.get("join_condition").asText());
                        }
                        for (JsonNode eachRow3 : subResources2) {
                            String resourceName3 = eachRow3.get("name").asText();
                            if (!resourceName3.equals(childName)) continue;
                            return eachRow3;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static String getDataTypeFromTable(String resourceName, String field, boolean cache, String preConfParam) {
        Hashtable<String, String> htPkForThisReource;
        int idxSepar = field.indexOf("--");
        if (idxSepar > -1) {
            field = field.substring(0, idxSepar);
        }
        JsonNode resource = null;
        try {
            resource = JSonClient.get("@tables/" + JSonClient.cleanNoDBPrefix(resourceName), null, cache, preConfParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resource.get("errorCode") == null && (htPkForThisReource = resourceHtPK.get(resourceName)) == null) {
            htPkForThisReource = new Hashtable();
            boolean is31 = false;
            if (resource.get("keys") != null) {
                JsonNode pkFieldList = resource.get("keys");
                int i = 0;
                for (JsonNode eachRow : pkFieldList) {
                    if (!eachRow.get("type").asText().equalsIgnoreCase("primary")) continue;
                    Iterator colsKey = eachRow.get("columns").elements();
                    while (colsKey.hasNext()) {
                        String fieldName = ((JsonNode)colsKey.next()).asText();
                        htPkForThisReource.put("pkField" + i, fieldName);
                        ++i;
                    }
                    resourceHtPK.put(resourceName, htPkForThisReource);
                }
                JsonNode fieldList = resource.get("columns");
                for (JsonNode eachRow : fieldList) {
                    String fieldName = eachRow.get("name").asText();
                    if (!fieldName.equals(field)) continue;
                    String genericType = eachRow.get("generic_type").asText();
                    String type = eachRow.get("type").asText();
                    if (genericType.equals("text")) {
                        if (eachRow.get("size") != null && eachRow.get("size").asInt() > 512 || eachRow.get("db_column_type").equals((Object)"longtext")) {
                            return "memo";
                        }
                        return "text";
                    }
                    if (type.equals("DECIMAL")) {
                        return "DECIMAL";
                    }
                    return genericType;
                }
            }
        }
        return null;
    }

    public static Hashtable<String, Hashtable<String, String>> getResourceHtPK() {
        return resourceHtPK;
    }

    public static JsonNode getColumnsFromTable(String resourceName, String subResourceName, boolean cache, String preConfParam) {
        ObjectNode listFields = new ObjectNode(nodeFactory);
        ArrayNode rowFields = new ArrayNode(nodeFactory);
        String ident = "";
        if (resourceName == null) {
            resourceName = subResourceName.substring(5);
        }
        JsonNode resource = null;
        try {
            resource = JSonClient.get("@tables/" + JSonClient.cleanNoDBPrefix(resourceName), null, cache, preConfParam);
        }
        catch (Exception e) {
            System.out.println("is probably a reource not a table");
        }
        if (resource.get("errorCode") == null) {
            Object eachRow2;
            JsonNode fieldList = resource.get("columns");
            for (Object eachRow2 : fieldList) {
                String fieldName = eachRow2.get("name").asText();
                String dataType = eachRow2.get("generic_type").asText();
                listFields.put(fieldName, dataType);
            }
            JsonNode parentList = resource.get("parents");
            eachRow2 = parentList.iterator();
            while (eachRow2.hasNext()) {
                JsonNode eachRow3;
                JsonNode parentNode = eachRow3 = (JsonNode)eachRow2.next();
                String fieldName = eachRow3.get("child_columns").get(0).asText();
                parents.put(fieldName, parentNode);
                parentsResource.put(resourceName, parents);
            }
        } else {
            int posPointForSubR = resourceName.indexOf(".");
            if (posPointForSubR > -1) {
                subResourceName = resourceName.substring(posPointForSubR + 1);
                resourceName = resourceName.substring(0, posPointForSubR);
            }
            ident = JSonClient.getIdentOfResource(resourceName, cache, preConfParam);
            try {
                if (ident != null) {
                    resource = JSonClient.get("@resources/" + ident, null, cache, preConfParam);
                    if (resource != null) {
                        JSonClient.keepJoinConditionSubResources(resource);
                        if (subResourceName != null && subResourceName.length() > 1) {
                            resource = JSonClient.getSubResourceTable(resource, subResourceName);
                        }
                        if (resource != null) {
                            JsonNode fieldList = resource.get("attributes");
                            String tableName = resource.get("table_name").asText();
                            JSonClient.setResourceTableName(tableName);
                            for (JsonNode eachRow : fieldList) {
                                String fieldName = eachRow.get("column_name").asText();
                                String dataType = JSonClient.getDataTypeFromTable(tableName, fieldName, cache, preConfParam);
                                listFields.put(fieldName, dataType);
                            }
                            JsonNode subresources = resource.get("subresources");
                            for (JsonNode eachRow : subresources) {
                                JsonNode fieldListSR = eachRow.get("attributes");
                                tableName = eachRow.get("table_name").asText();
                                String name = eachRow.get("name").asText();
                                if (!name.equals(subResourceName) && !name.startsWith("FK-")) continue;
                                for (JsonNode eachRowSR : fieldListSR) {
                                    String fieldName = eachRowSR.get("column_name").asText();
                                    String dataType = JSonClient.getDataTypeFromTable(tableName, fieldName, cache, preConfParam);
                                    listFields.put(fieldName, dataType);
                                }
                            }
                        }
                        System.err.println("************ERROR subResourceName NO EXISTE : " + subResourceName);
                    }
                    System.err.println("************ STRANGE ERROR----> resource not found After found IDENT ***********--->" + resourceName);
                }
                System.err.println("************ IDENT resource not found ***********--->" + resourceName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rowFields.add((JsonNode)listFields);
        return rowFields;
    }

    public static void keepFKinHT(String resourceName, String subResourceName, boolean cache, String preConfParam) {
        String ident = "";
        if (resourceName == null) {
            resourceName = subResourceName.substring(5);
        }
        JsonNode resource = null;
        int posPointForSubR = resourceName.indexOf(".");
        if (posPointForSubR > -1) {
            subResourceName = resourceName.substring(posPointForSubR + 1);
            resourceName = resourceName.substring(0, posPointForSubR);
        }
        ident = JSonClient.getIdentOfResource(resourceName, cache, preConfParam);
        try {
            if (ident != null) {
                resource = JSonClient.get("@resources/" + ident, null, cache, preConfParam);
                JSonClient.keepJoinConditionSubResources(resource);
            } else {
                System.err.println("************ IDENT resource not found ***********--->" + resourceName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void keepJoinConditionSubResources(JsonNode resource) {
        String parentResource = resource.get("name").asText();
        JsonNode subResources = resource.get("subresources");
        if (subResources != null && subResources.size() > 0) {
            for (JsonNode eachRow : subResources) {
                JsonNode subResources1;
                String childResource = eachRow.get("name").asText();
                String resourceNameWithParent = JSonClient.getResourceName(parentResource, childResource);
                if (ht.get(resourceNameWithParent) == null) {
                    ht.put(resourceNameWithParent, JSonClient.cleanEmptyJoin(eachRow.get("join_condition").asText()));
                }
                if ((subResources1 = eachRow.get("subresources")) == null || !subResources1.elements().hasNext()) continue;
                for (JsonNode eachRow1 : subResources1) {
                    JsonNode subResources2;
                    String resourceName1;
                    String childResource1 = eachRow1.get("name").asText();
                    String resourceNameWithParent1 = JSonClient.getResourceName(resourceNameWithParent, childResource1);
                    if (ht.get(resourceNameWithParent1) == null) {
                        ht.put(resourceNameWithParent1, JSonClient.cleanEmptyJoin(eachRow1.get("join_condition").asText()));
                    }
                    if (ht.get(resourceName1 = JSonClient.getResourceName(childResource, childResource1)) == null) {
                        ht.put(resourceName1, JSonClient.cleanEmptyJoin(eachRow1.get("join_condition").asText()));
                    }
                    if ((subResources2 = eachRow1.get("subresources")) == null || !subResources2.elements().hasNext()) continue;
                    for (JsonNode eachRow2 : subResources2) {
                        JsonNode subResources3;
                        String resourceName2;
                        String childResource2 = eachRow2.get("name").asText();
                        String resourceNameWithParent2 = JSonClient.getResourceName(resourceNameWithParent1, childResource2);
                        if (ht.get(resourceNameWithParent2) == null) {
                            ht.put(resourceNameWithParent2, JSonClient.cleanEmptyJoin(eachRow2.get("join_condition").asText()));
                        }
                        if (ht.get(resourceName2 = JSonClient.getResourceName(childResource1, childResource2)) == null) {
                            ht.put(resourceName2, JSonClient.cleanEmptyJoin(eachRow1.get("join_condition").asText()));
                        }
                        if ((subResources3 = eachRow2.get("subresources")) == null || !subResources3.elements().hasNext()) continue;
                        for (JsonNode eachRow3 : subResources3) {
                            String resourceName3;
                            String childResource3 = eachRow3.get("name").asText();
                            String resourceNameWithParent3 = JSonClient.getResourceName(resourceNameWithParent2, childResource3);
                            if (ht.get(resourceNameWithParent3) == null) {
                                ht.put(resourceNameWithParent3, JSonClient.cleanEmptyJoin(eachRow3.get("join_condition").asText()));
                            }
                            if (ht.get(resourceName3 = JSonClient.getResourceName(childResource2, childResource3)) != null) continue;
                            ht.put(resourceName3, JSonClient.cleanEmptyJoin(eachRow1.get("join_condition").asText()));
                        }
                    }
                }
            }
        }
    }

    private static String cleanEmptyJoin(String join) {
        int posEmptyJoin = join.indexOf("EMPTYJOIN");
        if (join.indexOf("EMPTYJOIN") > -1) {
            int lastIdx = join.substring(11).indexOf("AND") + 15;
            String newJoin = join.substring(lastIdx);
            JSonClient.printLog(" newJoin " + newJoin);
            if (newJoin.indexOf("EMPTYJOIN") > -1) {
                DataService.get().showError("JOIN que incluye EMPTYJOIN mal definido, ha de ir por delante del JOIN real y ha de ser exactamente respectando May\u00fasculas y blancos -> \"EMPTYJOIN\" = [\"EMPTYJOIN\"] \n AND ");
            }
            return newJoin;
        }
        return join;
    }

    private static String getResourceName(String parentResource, String childResource) {
        String resourceName = parentResource + "." + childResource;
        return resourceName;
    }

    public static void putParentsInCache(String resourceName, boolean cache, String preConfParam) {
        JsonNode resource = null;
        try {
            resource = JSonClient.get("@tables/" + JSonClient.cleanNoDBPrefix(resourceName), null, cache, preConfParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resource.get("errorCode") == null) {
            JsonNode parentList = resource.get("parents");
            Iterator iterator = parentList.iterator();
            while (iterator.hasNext()) {
                JsonNode eachRow;
                JsonNode parentNode = eachRow = (JsonNode)iterator.next();
                String fieldName = eachRow.get("child_columns").get(0).asText();
                parents.put(fieldName, parentNode);
                parentsResource.put(resourceName, parents);
            }
        }
    }

    public static Hashtable<String, JsonNode> getParents() {
        return parents;
    }

    public static Hashtable<String, Hashtable<String, JsonNode>> getParentsResource() {
        return parentsResource;
    }

    public static Hashtable<String, String> getHt() {
        return ht;
    }

    public static String getTableNameRoot() {
        return tableNameRoot;
    }

    public static void setTableNameRoot(String tableNameRoot) {
        JSonClient.tableNameRoot = tableNameRoot;
    }

    public void fillKeepJson(String resource, String filter, boolean useCache, String preConfParam) {
        try {
            this.keepJson = JSonClient.get(resource, filter, useCache, preConfParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getRowCount() {
        if (this.keepJson != null) {
            return this.keepJson.size();
        }
        return 0;
    }

    public String getValueFromRow(String field, int rowNumber) {
        return this.keepJson.get(rowNumber).get(field).asText();
    }

    public String getValueFromRow(String node, String field, int rowNumber) {
        if (this.keepJson.get(rowNumber).get(node) != null) {
            return this.keepJson.get(rowNumber).get(node).get(field).asText();
        }
        return "null";
    }

    public String getValueFromRow(String node1, String node2, String field, int rowNumber) {
        if (this.keepJson.get(rowNumber).get(node1) == null) {
            return "null";
        }
        if (this.keepJson.get(rowNumber).get(node1).get(node2) == null) {
            return "null";
        }
        return this.keepJson.get(rowNumber).get(node1).get(node2).get(field).asText();
    }

    public String getResult() {
        return this.keepJson.toString();
    }

    public static void setApiKeyHeader(String apiKey) {
        apiKeyHeader = new BasicHeader("Authorization", apiKey);
    }

    public static void setBaseURL(String baseURL) {
        JSonClient.baseURL = baseURL;
    }

    public static String getResourceTableName() {
        return resourceTableName;
    }

    public static void setResourceTableName(String resourceTableName) {
        JSonClient.resourceTableName = resourceTableName;
    }

    static {
        ht = new Hashtable();
        resourceHtPK = new Hashtable();
        parents = new Hashtable();
        parentsResource = new Hashtable();
        kbaseURL = "";
        keepIdent = new Hashtable();
    }
}

