/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.espresso.presutec.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;

public class JSonClientActiviti {
    private static CloseableHttpClient client = HttpClientBuilder.create().build();
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
    protected static String SERVER;
    static String BASE_URL;
    protected static String API_KEY;
    private static final Header API_KEY_HEADER;
    private static Hashtable<String, JsonNode> jsonCaches;

    public static void main(String[] args) throws Exception {
        System.setProperty("javax.net.ssl.trustStore", "src/main/resources/mykeystore");
        System.out.println("\n\n------ Retrieve all customers using BASE_URL: " + BASE_URL);
        JsonNode taskList = JSonClientActiviti.get("tasks", "candidate-group=espressoLogic", true).get("data");
        System.out.println("taskList " + taskList);
        for (JsonNode eachTask : taskList) {
            System.out.println("createTime: " + eachTask.get("createTime").asText());
            System.out.println("owner " + eachTask.get("owner").asText());
            System.out.println("   description: " + eachTask.get("description").asText());
        }
        System.out.println("\n------ Test is complete");
    }

    public static JsonNode get(String resource, String filter, boolean useCache) throws Exception {
        String url = BASE_URL + resource;
        if (filter != null) {
            url = url + filter;
        }
        System.out.println("tengo en url : " + url);
        HttpGet get = new HttpGet(url);
        get.addHeader(API_KEY_HEADER);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        JsonNode parResponse = JSonClientActiviti.parseResponse((HttpResponse)response);
        System.out.println("tengo en response : " + parResponse);
        return parResponse.get("data");
    }

    private static JsonNode getJsonCache(String resource) {
        if (jsonCaches.get(resource) != null) {
            return jsonCaches.get(resource);
        }
        return null;
    }

    public static JsonNode get(String url) throws Exception {
        System.out.println("tengo en url : " + url);
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        JsonNode parResponse = JSonClientActiviti.parseResponse((HttpResponse)response);
        return parResponse;
    }

    public static JsonNode put(String resource, JsonNode object) throws Exception {
        HttpPut put = new HttpPut(BASE_URL + resource);
        put.addHeader(API_KEY_HEADER);
        StringEntity entity = new StringEntity(object.toString(), "UTF-8");
        entity.setContentType("application/json");
        put.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)put);
        JsonNode parResponse = JSonClientActiviti.parseResponse((HttpResponse)response);
        return parResponse;
    }

    public static JsonNode post(String resource, JsonNode object) throws Exception {
        HttpPost post = new HttpPost(BASE_URL + resource);
        System.err.println(" URL para POST " + BASE_URL + resource);
        post.addHeader(API_KEY_HEADER);
        StringEntity entity = new StringEntity(object.toString(), "UTF-8");
        entity.setContentType("application/json");
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        JsonNode parResponse = null;
        if (response.getEntity() != null) {
            parResponse = JSonClientActiviti.parseResponse((HttpResponse)response);
        }
        return parResponse;
    }

    public static JsonNode delete(JsonNode object) throws Exception {
        String objectUrl = object.get("@metadata").get("href").asText();
        String checksum = object.get("@metadata").get("checksum").asText();
        HttpDelete delete = new HttpDelete(objectUrl + "?checksum=" + checksum);
        delete.addHeader(API_KEY_HEADER);
        CloseableHttpResponse response = client.execute((HttpUriRequest)delete);
        JsonNode parResponse = JSonClientActiviti.parseResponse((HttpResponse)response);
        return parResponse;
    }

    private static JsonNode parseResponse(HttpResponse response) throws Exception {
        InputStreamReader inStr = new InputStreamReader(response.getEntity().getContent());
        BufferedReader rd = new BufferedReader(inStr);
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = rd.readLine()) != null) {
            sb.append(line);
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode inData = mapper.readTree(sb.toString());
        return inData;
    }

    private static String getFieldLocale(String field) {
        String clave = field;
        ResourceBundle labels = ResourceBundle.getBundle("ResourceBundle", new Locale("es", "ES"));
        Enumeration<String> bundleKeys = labels.getKeys();
        clave = labels.getString(field);
        return clave;
    }

    static {
        BASE_URL = SERVER = "http://activiti.intergal.coop/activiti-rest/service/";
        API_KEY = "Basic Y3FyOnAxMjNzYWRv";
        API_KEY_HEADER = new BasicHeader("Authorization", API_KEY);
        jsonCaches = new Hashtable();
    }
}

