/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ldap;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class LdapTest2 {
    public void run() {
        try {
            DirContext context = LdapTest2.getContext();
            String name = "uid=tu_usuario2,ou=central,ou=gfer,ou=tys,ou=groups,dc=intergal,dc=coop";
            LdapTest2.createLDAPUser(name, "password", null, "snvalue", "cnvalue");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public static void createLDAPUser(String name, String password, Hashtable<String, String> fieldsAndData, String snvalue, String cnvalue) throws NamingException {
        DirContext context = LdapTest2.getContext();
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute attribute = new BasicAttribute("objectClass");
        attribute.add("inetOrgPerson");
        attribute.add("organizationalPerson");
        attribute.add("person");
        attribute.add("top");
        attributes.put(attribute);
        BasicAttribute sn = new BasicAttribute("sn");
        sn.add(snvalue);
        attributes.put(sn);
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add(cnvalue);
        attributes.put(cn);
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        userPassword.add(encoder.encode((CharSequence)password));
        attributes.put(userPassword);
        if (fieldsAndData != null) {
            Enumeration<String> fieldsAndDataELE = fieldsAndData.keys();
            while (fieldsAndDataELE.hasMoreElements()) {
                String field = fieldsAndDataELE.nextElement();
                String data = fieldsAndData.get(field);
                attributes.put(field, data);
            }
        }
        context.createSubcontext(name, (Attributes)attributes);
    }

    public static String changePassword(String name, String oldPass, String newPass) throws NamingException, UnsupportedEncodingException {
        DirContext context = LdapTest2.getContext();
        ModificationItem[] mods = new ModificationItem[1];
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        Attributes attrs = context.getAttributes(name);
        byte[] v = (byte[])attrs.get("userPassword").get();
        String saveOldPass = new String(v);
        BasicAttribute oldUserPassword = new BasicAttribute("userPassword");
        boolean isSavedPass = encoder.matches((CharSequence)oldPass, saveOldPass);
        if (isSavedPass) {
            oldUserPassword.add(encoder.encode((CharSequence)newPass));
            mods[0] = new ModificationItem(2, oldUserPassword);
            context.modifyAttributes(name, mods);
            return "OK";
        }
        return "WRONG OLD PASSWORD";
    }

    private void removeLDAPObject(DirContext context, String name) throws NamingException {
        context.destroySubcontext(name);
    }

    private void createLDAPObject(DirContext context, String name) throws NamingException {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute attribute = new BasicAttribute("objectClass");
        attribute.add("inetOrgPerson");
        attribute.add("organizationalPerson");
        attribute.add("person");
        attribute.add("top");
        attributes.put(attribute);
        BasicAttribute sn = new BasicAttribute("sn");
        sn.add("Steve2");
        attributes.put(sn);
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add("terra");
        attributes.put(cn);
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        userPassword.add("$2a$10$c6bSeWPhg06xB1lvmaWNNe4NROmZiSpYhlocU/98HNr2MhIOiSt36");
        attributes.put(userPassword);
        attributes.put("telephoneNumber", "1234");
        context.createSubcontext(name, (Attributes)attributes);
    }

    private void removeAttribute(DirContext context, String name, String attrName) throws NamingException {
        BasicAttribute attribute = new BasicAttribute(attrName);
        ModificationItem[] item = new ModificationItem[]{new ModificationItem(3, attribute)};
        context.modifyAttributes(name, item);
    }

    private void createAttribute(DirContext context, String name, String attrName, Object attrValue) throws NamingException {
        BasicAttribute attribute = new BasicAttribute(attrName, attrValue);
        ModificationItem[] item = new ModificationItem[]{new ModificationItem(1, attribute)};
        context.modifyAttributes(name, item);
    }

    private void updateAttribute(DirContext context, String name, String attrName, Object attrValue) throws NamingException {
        BasicAttribute attribute = new BasicAttribute(attrName, attrValue);
        ModificationItem[] item = new ModificationItem[]{new ModificationItem(2, attribute)};
        context.modifyAttributes(name, item);
    }

    private void viewAttribute(DirContext context, String name, String attrName) throws NamingException {
        Attributes attrs = context.getAttributes(name);
        System.out.println(attrName + ":" + attrs.get(attrName).get());
    }

    private static DirContext getContext() throws NamingException {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", "ldap://lac1.intergal.coop:389");
        properties.put("java.naming.security.credentials", "intergalldapadmin");
        properties.put("java.naming.security.principal", "cn=admin,dc=intergal,dc=coop");
        return new InitialDirContext(properties);
    }

    public static void main(String[] args) {
        new LdapTest2().run();
    }
}

