/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.templatemodel.TemplateModel;
import coop.intergal.ui.SubSubmenu;
import coop.intergal.ui.components.FlexBoxLayout;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@Tag(value="sub-menu")
@JsModule(value="./src/sub-menu.js")
@Route(value="submenuGeneric")
public class SubMenu
extends PolymerTemplate<TemplateModel>
implements BeforeEnterObserver,
HasDynamicTitle {
    private static final long serialVersionUID = 1L;
    @Id(value="dvTabs")
    private Div dvTabs;
    @Id(value="dvPages")
    private Div dvPages;
    private String filter;
    private Tabs tabs = new Tabs(false, new Tab[0]);
    private Tab tab1;
    private Div page1;
    private Div pages = new Div();
    private String title = "Menu principal (" + UtilSessionData.getCompanyYear() + ")";
    private ArrayList<String[]> rowsColList;
    private String filtertab;

    public ArrayList<String[]> getRowsColList() {
        return this.rowsColList;
    }

    public void setRowsColList(ArrayList<String[]> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        QueryParameters queryParameters = event.getLocation().getQueryParameters();
        this.filter = (String)((List)queryParameters.getParameters().get("filter")).get(0);
        this.filter = this.filter.replace("EEQQ", "=");
        this.title = (String)((List)queryParameters.getParameters().get("title")).get(0);
        this.setupButtons();
    }

    private void setupButtons() {
        DdbDataBackEndProvider dataProvider = new DdbDataBackEndProvider();
        System.out.println("SubMenu.setupButtons() " + this.filter);
        dataProvider.setPreConfParam(UtilSessionData.getCompanyYear() + "TYSLac0");
        dataProvider.setResourceName("CR-menu");
        this.rowsColList = dataProvider.getRowsColList();
        List<DynamicDBean> menuList = RestData.getResourceData(0, 0, "CR-menu", "metadataLac0", this.rowsColList, this.filter, false, false, null);
        Iterator itMenuList = menuList.iterator();
        this.tabs.removeAll();
        HashMap<Tab, Div> tabsToPages = new HashMap<Tab, Div>();
        while (itMenuList.hasNext()) {
            Div div = new Div();
            div.getStyle().set("display", "table");
            div.getStyle().set("width", "100%");
            DynamicDBean rowMenu = (DynamicDBean)itMenuList.next();
            String optionName = rowMenu.getCol0().toString();
            this.filtertab = "isFKidMenu=" + rowMenu.getRowJSon().get("idMenu").asText();
            this.dvTabs.getStyle().set("display", "inherit");
            this.tab1 = new Tab(optionName);
            this.tabs.add(new Tab[]{this.tab1});
            this.page1 = new Div();
            this.page1.getStyle().set("display", "table");
            this.page1.getStyle().set("width", "100%");
            this.pages.getStyle().set("width", "100%");
            SubSubmenu laPage = new SubSubmenu(this.filtertab);
            this.page1.add(new Component[]{laPage});
            this.page1.setVisible(false);
            tabsToPages.put(this.tab1, this.page1);
            this.tabs.add(new Tab[]{this.tab1});
            this.pages.add(new Component[]{this.page1});
            this.tabs.addSelectedChangeListener((ComponentEventListener & Serializable)event -> {
                tabsToPages.values().forEach(page -> page.setVisible(false));
                Component selectedPage = (Component)tabsToPages.get(this.tabs.getSelectedTab());
                if (selectedPage != null) {
                    selectedPage.setVisible(true);
                }
            });
            this.dvTabs.add(new Component[]{this.tabs});
            this.dvPages.add(new Component[]{this.pages});
        }
    }

    public String getPageTitle() {
        System.out.println("SubMenu.getPageTitle() " + this.title);
        try {
            this.title = URLDecoder.decode(this.title, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        FlexBoxLayout p1 = (FlexBoxLayout)((Object)this.getParent().get());
        Component p2 = (Component)p1.getParent().get();
        Component p3 = (Component)p2.getParent().get();
        return UtilSessionData.addCompanyToTitle(this.title);
    }
}

