/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.data.binder.BeanValidationBinder;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.templatemodel.TemplateModel;
import coop.intergal.ui.components.FlexBoxLayout;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.vaadin.rest.utils.DataService;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Tag(value="sub-submenu")
@JsModule(value="./src/sub-submenu.js")
@Route(value="ssubmenuGeneric")
public class SubSubmenu
extends PolymerTemplate<TemplateModel>
implements BeforeEnterObserver,
HasDynamicTitle {
    private static final long serialVersionUID = 1L;
    @Id(value="butomGroup1")
    private VerticalLayout vlButomsGroup1;
    private String losThemes;
    private String filter = "";
    private final BeanValidationBinder<DynamicDBean> binder = new BeanValidationBinder(DynamicDBean.class);
    private ArrayList<String[]> rowsColList;
    private String title = "Menu principal";
    private int esTab = 0;

    public ArrayList<String[]> getRowsColList() {
        return this.rowsColList;
    }

    public void setRowsColList(ArrayList<String[]> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public SubSubmenu() {
    }

    public SubSubmenu(String filter2) {
        this.filter = filter2;
        this.esTab = 1;
        this.setupButtons();
    }

    private void setupButtons() {
        System.out.println("SubSubmenu.setupButtons(XX) cambio " + this.filter);
        this.vlButomsGroup1.removeAll();
        if (UtilSessionData.getCompanyYear() == null || UtilSessionData.getCompanyYear().isEmpty()) {
            DataService.get().showError("Primero debe seleccionar la Empresa, pulse en el logo.");
            return;
        }
        DdbDataBackEndProvider dataProvider = new DdbDataBackEndProvider();
        dataProvider.setPreConfParam(UtilSessionData.getCompanyYear() + "TYSLac0");
        dataProvider.setResourceName("CR-menu");
        this.rowsColList = dataProvider.getRowsColList();
        List<DynamicDBean> menuList = RestData.getResourceData(0, 0, "CR-menu", "metadataLac0", this.rowsColList, this.filter, UtilSessionData.getCache(), false, null);
        Iterator itMenuList = menuList.iterator();
        while (itMenuList.hasNext()) {
            Div div = new Div();
            div.getStyle().set("display", "table");
            div.getStyle().set("width", "100%");
            DynamicDBean rowMenu = (DynamicDBean)itMenuList.next();
            String optionName = rowMenu.getCol0().toString();
            String resourceName = rowMenu.getCol4();
            if (resourceName.equals("null") || resourceName.length() == 0) {
                Button titulo = new Button(optionName);
                this.losThemes = rowMenu.getRowJSon().get("theme").asText();
                titulo.addThemeNames(new String[]{this.losThemes});
                div.add(new Component[]{titulo});
                JsonNode rowNode = rowMenu.getRowJSon();
                Iterator subMenus = rowNode.get("List-menu").elements();
                while (subMenus.hasNext()) {
                    Paragraph div2 = new Paragraph();
                    div2.getStyle().set("margin", "0");
                    JsonNode rowSubMenu = (JsonNode)subMenus.next();
                    String optionNameSubmenu = rowSubMenu.get("optionName").asText();
                    Button button1 = new Button(optionNameSubmenu, (ComponentEventListener & Serializable)evt -> this.processButon(rowSubMenu));
                    this.losThemes = rowSubMenu.get("theme").asText();
                    button1.addThemeNames(new String[]{this.losThemes});
                    String microHelp = rowSubMenu.get("microHelp").asText();
                    if (microHelp != null && !microHelp.equals("null")) {
                        button1.getElement().setAttribute("title", microHelp);
                    }
                    div2.add(new Component[]{button1});
                    div.add(new Component[]{div2});
                }
            } else {
                Button button1 = new Button(optionName, (ComponentEventListener & Serializable)evt -> this.processButon(rowMenu.getRowJSon()));
                String losThemes = rowMenu.getRowJSon().get("theme").asText();
                String microHelp = rowMenu.getRowJSon().get("microHelp").asText();
                button1.addThemeNames(new String[]{losThemes});
                button1.getElement().setAttribute("title", microHelp);
                div.add(new Component[]{button1});
                int countSubmenus = 0;
                if (rowMenu.getRowJSon().get("countSubmenus") != null && !rowMenu.getRowJSon().get("countSubmenus").asText().equals("null")) {
                    countSubmenus = rowMenu.getRowJSon().get("countSubmenus").asInt();
                }
                if (countSubmenus > 0) {
                    ContextMenu contextmenu = new ContextMenu();
                    JsonNode rowNode = rowMenu.getRowJSon();
                    Iterator subMenus = rowNode.get("List-menu").elements();
                    while (subMenus.hasNext()) {
                        JsonNode rowSubMenu = (JsonNode)subMenus.next();
                        String optionNameSubmenu = rowSubMenu.get("optionName").asText();
                        contextmenu.addItem(optionNameSubmenu, (ComponentEventListener & Serializable)evt -> this.processButon(rowSubMenu));
                    }
                    contextmenu.setTarget((Component)button1);
                }
            }
            this.vlButomsGroup1.add(new Component[]{div});
        }
    }

    private Object processButon(JsonNode rowSubMenu) {
        String titleOption = rowSubMenu.get("optionName").asText();
        String layoutPage = rowSubMenu.get("layoutPage").asText();
        if (layoutPage == null || layoutPage.isEmpty() || layoutPage.equals("null")) {
            layoutPage = "dynamicQGD";
        } else if (layoutPage.equals("PAGE_DYNAMIC_QGD")) {
            layoutPage = "dynamicQGD";
        } else if (layoutPage.equals("PAGE_DYNAMIC_QG")) {
            layoutPage = "dynamicQG";
        } else if (layoutPage.equals("PAGE_DYNAMIC_GD")) {
            layoutPage = "dynamicGD";
        } else {
            DataService.get().showError("valor invalido para layoutPage, debe de ser (PAGE_DYNAMIC_QG o PAGE_DYNAMIC_QGD o PAGE_DYNAMIC_TREE");
        }
        try {
            String urlBase = "../" + layoutPage;
            String hostName = InetAddress.getLocalHost().getHostName();
            if (hostName.indexOf(".local") == -1 && hostName.indexOf("FC-NB-MLOPEZ") == -1) {
                urlBase = "../tys22/" + layoutPage;
            }
            String resource = rowSubMenu.get("resource").asText();
            String queryFormClassName = rowSubMenu.get("queryFormClassName").asText();
            String displayFormClassName = rowSubMenu.get("displayFormClassName").asText();
            String addFormClassName = rowSubMenu.get("addFormClassName").asText();
            String idMenu = rowSubMenu.get("idMenu").asText();
            UI.getCurrent().getPage().executeJs("window.open('" + urlBase + "?resourceName=" + resource + "&queryFormClassName=" + queryFormClassName + "&displayFormClassName=" + displayFormClassName + "&addFormClassName=" + addFormClassName + "&title=" + titleOption + "&idMenu=" + idMenu + "', '_blank');", new Serializable[0]);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        if (this.esTab == 0) {
            QueryParameters queryParameters = event.getLocation().getQueryParameters();
            this.filter = (String)((List)queryParameters.getParameters().get("filter")).get(0);
            this.filter = this.filter.replace("EEQQ", "=");
            this.title = (String)((List)queryParameters.getParameters().get("title")).get(0);
            this.setupButtons();
        }
    }

    public String getPageTitle() {
        try {
            this.title = URLDecoder.decode(this.title, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        FlexBoxLayout p1 = (FlexBoxLayout)((Object)this.getParent().get());
        Component p2 = (Component)p1.getParent().get();
        Component p3 = (Component)p2.getParent().get();
        return UtilSessionData.addCompanyToTitle(this.title);
    }
}

