/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.IronIcon;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.templatemodel.TemplateModel;
import coop.intergal.ui.entities.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

@Tag(value="app-navigation")
@JsModule(value="./src/components/app-navigation.js")
public class AppNavigation
extends PolymerTemplate<TemplateModel>
implements AfterNavigationObserver {
    @Id(value="tabs")
    private Tabs tabs;
    private List<String> hrefs = new ArrayList<String>();
    private List<QueryParameters> listQParams = new ArrayList<QueryParameters>();
    private String logoutHref;
    private String defaultHref;
    private String currentHref;

    public void init(List<PageInfo> pages, String defaultHref, String logoutHref) {
        this.logoutHref = logoutHref;
        this.defaultHref = defaultHref;
        for (PageInfo page : pages) {
            Tab tab = new Tab(new Component[]{new IronIcon("vaadin", page.getIcon()), new Span(page.getTitle())});
            tab.getElement().setAttribute("theme", "icon-on-top");
            String paramsList = page.getParamsList();
            QueryParameters queryParameters = null;
            if (paramsList != null) {
                queryParameters = this.fillParams(page.getParamsList());
            }
            this.listQParams.add(queryParameters);
            this.hrefs.add(page.getLink());
            this.tabs.add(new Tab[]{tab});
        }
        this.tabs.addSelectedChangeListener((ComponentEventListener & Serializable)e -> this.navigate());
    }

    private QueryParameters fillParams(String paramsList) {
        HashMap parameters = new HashMap();
        StringTokenizer tokens = new StringTokenizer(paramsList, "&");
        while (tokens.hasMoreTokens()) {
            ArrayList<String> values = new ArrayList<String>();
            String param = tokens.nextToken();
            String[] paramAndValue = param.split("=");
            values.add(paramAndValue[1]);
            parameters.put(paramAndValue[0], values);
        }
        QueryParameters queryParameters = new QueryParameters(parameters);
        return queryParameters;
    }

    private void navigate() {
        int idx = this.tabs.getSelectedIndex();
        if (idx >= 0 && idx < this.hrefs.size()) {
            String href = this.hrefs.get(idx);
            QueryParameters qParams = this.listQParams.get(idx);
            if (href.equals(this.logoutHref)) {
                UI.getCurrent().getPage().executeJavaScript("location.assign('logout')", new Serializable[0]);
            } else if (!href.equals(this.currentHref)) {
                if (qParams != null) {
                    UI.getCurrent().navigate(href, qParams);
                } else {
                    UI.getCurrent().navigate(href);
                }
            }
        }
    }

    public void afterNavigation(AfterNavigationEvent event) {
        String href;
        this.currentHref = href = event.getLocation().getFirstSegment().isEmpty() ? this.defaultHref : event.getLocation().getFirstSegment();
        if (this.hrefs.indexOf(href) > 0) {
            this.tabs.setSelectedIndex(this.hrefs.indexOf(href));
        }
    }
}

