/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.spring.annotation.SpringComponent;
import org.springframework.context.annotation.Scope;

@Tag(value="confirm-dialog")
@JsModule(value="./src/components/confirm-dialog.js")
@Scope(value="prototype")
@SpringComponent
public class ConfirmDialog
extends Component {
    public ConfirmDialog() {
        this.getElement().synchronizeProperty("opened", "opened-changed");
    }

    public void setOpened(boolean value) {
        this.getElement().setProperty("opened", value);
    }

    public String getCaption() {
        return this.getElement().getProperty("caption");
    }

    public void setCaption(String caption) {
        this.getElement().setProperty("caption", caption == null ? "" : caption);
    }

    public void setMessage(String message) {
        this.getElement().setProperty("message", message == null ? "" : message);
    }

    public void setOkText(String okText) {
        this.getElement().setProperty("okText", okText == null ? "" : okText);
    }

    public void setCancelText(String cancelText) {
        this.getElement().setProperty("cancelText", cancelText == null ? "" : cancelText);
    }

    public Registration addCancelClickListener(ComponentEventListener<CancelClickEvent> listener) {
        return this.addListener(CancelClickEvent.class, listener);
    }

    public Registration addOkClickListener(ComponentEventListener<OkClickEvent> listener) {
        return this.addListener(OkClickEvent.class, listener);
    }

    @DomEvent(value="ok-click")
    public static class OkClickEvent
    extends ComponentEvent<ConfirmDialog> {
        public OkClickEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="cancel-click")
    public static class CancelClickEvent
    extends ComponentEvent<ConfirmDialog> {
        public CancelClickEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

