/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import coop.intergal.ui.layout.size.Size;
import coop.intergal.ui.util.css.BorderRadius;
import coop.intergal.ui.util.css.BoxSizing;
import coop.intergal.ui.util.css.Display;
import coop.intergal.ui.util.css.Overflow;
import coop.intergal.ui.util.css.Position;
import coop.intergal.ui.util.css.Shadow;

public class FlexBoxLayout
extends FlexLayout {
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BORDER_RADIUS = "border-radius";
    public static final String BOX_SHADOW = "box-shadow";
    public static final String BOX_SIZING = "box-sizing";
    public static final String DISPLAY = "display";
    public static final String FLEX_DIRECTION = "flex-direction";
    public static final String FLEX_WRAP = "flex-wrap";
    public static final String MAX_WIDTH = "max-width";
    public static final String OVERFLOW = "overflow";
    public static final String POSITION = "position";

    public FlexBoxLayout(Component ... components) {
        super(components);
    }

    public void setBackgroundColor(String value) {
        this.getStyle().set(BACKGROUND_COLOR, value);
    }

    public void setBackgroundColor(String value, String theme) {
        this.getStyle().set(BACKGROUND_COLOR, value);
        this.setTheme(theme);
    }

    public void removeBackgroundColor() {
        this.getStyle().remove(BACKGROUND_COLOR);
    }

    public void setBorderRadius(BorderRadius radius) {
        this.getStyle().set(BORDER_RADIUS, radius.getValue());
    }

    public void removeBorderRadius() {
        this.getStyle().remove(BORDER_RADIUS);
    }

    public void setBoxSizing(BoxSizing sizing) {
        this.getStyle().set(BOX_SIZING, sizing.getValue());
    }

    public void removeBoxSizing() {
        this.getStyle().remove(BOX_SIZING);
    }

    public void setDisplay(Display display) {
        this.getStyle().set(DISPLAY, display.getValue());
    }

    public void removeDisplay() {
        this.getStyle().remove(DISPLAY);
    }

    public void setFlex(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("flex", value);
        }
    }

    public void setFlexBasis(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("flex-basis", value);
        }
    }

    public void setFlexDirection(FlexLayout.FlexDirection direction) {
        this.getStyle().set(FLEX_DIRECTION, direction.values().toString());
    }

    public void removeFlexDirection() {
        this.getStyle().remove(FLEX_DIRECTION);
    }

    public void setFlexShrink(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("flex-shrink", value);
        }
    }

    public void setFlexWrap(FlexLayout.FlexWrap wrap) {
        this.getStyle().set(FLEX_WRAP, wrap.values().toString());
    }

    public void removeFlexWrap() {
        this.getStyle().remove(FLEX_WRAP);
    }

    public void setMargin(Size ... sizes) {
        for (Size size : sizes) {
            for (String attribute : size.getMarginAttributes()) {
                this.getStyle().set(attribute, size.getVariable());
            }
        }
    }

    public void removeMargin() {
        this.getStyle().remove("margin");
        this.getStyle().remove("margin-bottom");
        this.getStyle().remove("margin-left");
        this.getStyle().remove("margin-right");
        this.getStyle().remove("margin-top");
    }

    public void setMaxWidth(String value) {
        this.getStyle().set(MAX_WIDTH, value);
    }

    public void removeMaxWidth() {
        this.getStyle().remove(MAX_WIDTH);
    }

    public void setOverflow(Overflow overflow) {
        this.getStyle().set(OVERFLOW, overflow.getValue());
    }

    public void removeOverflow() {
        this.getStyle().remove(OVERFLOW);
    }

    public void setPadding(Size ... sizes) {
        for (Size size : sizes) {
            for (String attribute : size.getPaddingAttributes()) {
                this.getStyle().set(attribute, size.getVariable());
            }
        }
    }

    public void removePadding() {
        this.getStyle().remove("padding");
        this.getStyle().remove("padding-bottom");
        this.getStyle().remove("padding-left");
        this.getStyle().remove("padding-right");
        this.getStyle().remove("padding-top");
    }

    public void setPosition(Position position) {
        this.getStyle().set(POSITION, position.getValue());
    }

    public void removePosition() {
        this.getStyle().remove(POSITION);
    }

    public void setShadow(Shadow shadow) {
        this.getStyle().set(BOX_SHADOW, shadow.getValue());
    }

    public void removeShadow() {
        this.getStyle().remove(BOX_SHADOW);
    }

    public void setSpacing(Size ... sizes) {
        for (Size size : sizes) {
            this.addClassName(size.getSpacingClassName());
        }
    }

    public void setTheme(String theme) {
        if ("dark".equals(theme)) {
            this.getElement().setAttribute("theme", "dark");
        } else {
            this.getElement().removeAttribute("theme");
        }
    }
}

