/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Header;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;

@CssImport(value="./styles/my-dialog.css")
public class FloatingDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    public String DOCK = "dock";
    public String FULLSCREEN = "fullscreen";
    private boolean isDocked = false;
    private boolean isFullScreen = false;
    private Header header;
    private Button min;
    private Button max;
    private Component content;

    public FloatingDialog(Component queryForm) {
        this.content = queryForm;
        this.setDraggable(true);
        this.setModal(false);
        this.setResizable(true);
        this.getElement().getThemeList().add((Object)"my-dialog");
        this.setWidth("600px");
        this.getElement().setAttribute("aria-labelledby", "dialog-title");
        H2 title = new H2("B\u00fasqueda");
        title.addClassName("dialog-title");
        this.min = new Button((Component)VaadinIcon.DOWNLOAD_ALT.create());
        this.min.addClickListener((ComponentEventListener & Serializable)event -> this.minimise());
        this.max = new Button((Component)VaadinIcon.EXPAND_SQUARE.create());
        this.max.addClickListener((ComponentEventListener & Serializable)event -> this.maximise());
        Button close = new Button((Component)VaadinIcon.CLOSE_SMALL.create());
        close.addClickListener((ComponentEventListener & Serializable)event -> this.close());
        this.header = new Header(new Component[]{title, this.min, this.max, close});
        this.header.getElement().getThemeList().add((Object)"dark");
        this.add(new Component[]{this.header});
        this.add(new Component[]{this.content});
    }

    private void minimise() {
        if (this.isDocked) {
            this.initialSize();
        } else {
            if (this.isFullScreen) {
                this.initialSize();
            }
            this.min.setIcon((Component)VaadinIcon.UPLOAD_ALT.create());
            this.getElement().getThemeList().add((Object)this.DOCK);
            this.setWidth("320px");
        }
        this.isDocked = !this.isDocked;
        this.isFullScreen = false;
        this.content.setVisible(!this.isDocked);
    }

    private void initialSize() {
        this.min.setIcon((Component)VaadinIcon.DOWNLOAD_ALT.create());
        this.getElement().getThemeList().remove((Object)this.DOCK);
        this.max.setIcon((Component)VaadinIcon.EXPAND_SQUARE.create());
        this.getElement().getThemeList().remove((Object)this.FULLSCREEN);
        this.setHeight("auto");
        this.setWidth("600px");
    }

    private void maximise() {
        if (this.isFullScreen) {
            this.initialSize();
        } else {
            if (this.isDocked) {
                this.initialSize();
            }
            this.max.setIcon((Component)VaadinIcon.COMPRESS_SQUARE.create());
            this.getElement().getThemeList().add((Object)this.FULLSCREEN);
            this.setSizeFull();
            this.content.setVisible(true);
        }
        this.isFullScreen = !this.isFullScreen;
        this.isDocked = false;
    }
}

