/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.components;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DebounceSettings;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.templatemodel.TemplateModel;
import java.io.Serializable;

@Tag(value="search-bar")
@JsModule(value="./src/components/search-bar.js")
public class SearchBar
extends PolymerTemplate<Model> {
    @Id(value="field")
    private TextField textField;
    @Id(value="clear")
    private Button clearButton;
    @Id(value="action")
    private Button actionButton;

    public SearchBar() {
        this.textField.setValueChangeMode(ValueChangeMode.EAGER);
        ComponentUtil.addListener((Component)this.textField, SearchValueChanged.class, (ComponentEventListener & Serializable)e -> this.fireEvent(new FilterChanged(this, false)));
        this.clearButton.addClickListener((ComponentEventListener & Serializable)e -> {
            this.textField.clear();
            ((Model)this.getModel()).setCheckboxChecked(false);
        });
        this.getElement().addPropertyChangeListener("checkboxChecked", (PropertyChangeListener & Serializable)e -> this.fireEvent(new FilterChanged(this, false)));
    }

    public String getFilter() {
        return this.textField.getValue();
    }

    public boolean isCheckboxChecked() {
        return ((Model)this.getModel()).isCheckboxChecked();
    }

    public void setPlaceHolder(String placeHolder) {
        this.textField.setPlaceholder(placeHolder);
    }

    public void setActionText(String actionText) {
        ((Model)this.getModel()).setButtonText(actionText);
    }

    public void setCheckboxText(String checkboxText) {
        ((Model)this.getModel()).setCheckboxText(checkboxText);
    }

    public void addFilterChangeListener(ComponentEventListener<FilterChanged> listener) {
        this.addListener(FilterChanged.class, listener);
    }

    public void addActionClickListener(ComponentEventListener<ClickEvent<Button>> listener) {
        this.actionButton.addClickListener(listener);
    }

    public static class FilterChanged
    extends ComponentEvent<SearchBar> {
        public FilterChanged(SearchBar source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="value-changed", debounce=@DebounceSettings(timeout=300, phases={DebouncePhase.TRAILING}))
    public static class SearchValueChanged
    extends ComponentEvent<TextField> {
        public SearchValueChanged(TextField source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static interface Model
    extends TemplateModel {
        public boolean isCheckboxChecked();

        public void setCheckboxChecked(boolean var1);

        public void setCheckboxText(String var1);

        public void setButtonText(String var1);
    }
}

