/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.components.navigation.drawer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.HighlightCondition;
import com.vaadin.flow.router.HighlightConditions;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouterLink;
import coop.intergal.ui.util.UIUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@CssImport(value="styles/components/navi-item.css")
public class NaviItem
extends Div {
    private String CLASS_NAME = "navi-item";
    private int level = 0;
    private Component link;
    private Class<? extends Component> navigationTarget;
    private String text;
    protected Button expandCollapse;
    private List<NaviItem> subItems;
    private boolean subItemsVisible;
    private Map<String, List<String>> parameters;

    public NaviItem(VaadinIcon icon, String text, Class<? extends Component> navigationTarget) {
        this(text, navigationTarget, null);
        this.link.getElement().insertChild(0, new Element[]{new Icon(icon).getElement()});
    }

    public NaviItem(Image image, String text, Class<? extends Component> navigationTarget) {
        this(text, navigationTarget, null);
        this.link.getElement().insertChild(0, new Element[]{image.getElement()});
    }

    public NaviItem(VaadinIcon icon, String text, Class<? extends Component> navigationTarget, String parameter) {
        this(text, navigationTarget, null);
        this.link.getElement().insertChild(0, new Element[]{new Icon(icon).getElement()});
    }

    public NaviItem(VaadinIcon icon, String text, Class<? extends Component> navigationTarget, Map<String, List<String>> parameters) {
        this(text, navigationTarget, parameters);
        this.link.getElement().insertChild(0, new Element[]{new Icon(icon).getElement()});
    }

    public NaviItem(String text, Class<? extends Component> navigationTarget, Map<String, List<String>> parameters) {
        this.setClassName(this.CLASS_NAME);
        this.setLevel(0);
        this.text = text;
        this.navigationTarget = navigationTarget;
        if (navigationTarget != null && parameters != null) {
            QueryParameters queryParameters = new QueryParameters(parameters);
            RouterLink routerLink = new RouterLink(null, navigationTarget);
            routerLink.add(new Component[]{new Span(text)});
            routerLink.setClassName(this.CLASS_NAME + "__link");
            routerLink.setQueryParameters(queryParameters);
            routerLink.setHighlightCondition(HighlightConditions.sameLocation());
            this.link = routerLink;
        } else {
            Div div = new Div(new Component[]{new Span(text)});
            div.addClickListener((ComponentEventListener & Serializable)e -> this.expandCollapse.click());
            div.setClassName(this.CLASS_NAME + "__link");
            this.link = div;
        }
        this.expandCollapse = UIUtils.createButton(VaadinIcon.CARET_UP, ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_TERTIARY);
        this.expandCollapse.addClickListener((ComponentEventListener & Serializable)event -> this.setSubItemsVisible(!this.subItemsVisible));
        this.expandCollapse.setVisible(false);
        this.subItems = new ArrayList<NaviItem>();
        this.subItemsVisible = false;
        this.updateAriaLabel();
        this.add(new Component[]{this.link, this.expandCollapse});
    }

    public static HighlightCondition<RouterLink> sameLocation() {
        return (HighlightCondition & Serializable)(link, event) -> event.getLocation().getPathWithQueryParameters().equals(link.getHref());
    }

    private void updateAriaLabel() {
        String action = (this.subItemsVisible ? "Collapse " : "Expand ") + this.text;
        UIUtils.setAriaLabel(action, new Component[]{this.expandCollapse});
    }

    public boolean isHighlighted(AfterNavigationEvent e) {
        return this.link instanceof RouterLink && ((RouterLink)this.link).getHighlightCondition().shouldHighlight((Object)((RouterLink)this.link), e);
    }

    public void setLevel(int level) {
        this.level = level;
        if (level > 0) {
            this.getElement().setAttribute("level", Integer.toString(level));
        }
    }

    public int getLevel() {
        return this.level;
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget;
    }

    public void addSubItem(NaviItem item) {
        if (!this.expandCollapse.isVisible()) {
            this.expandCollapse.setVisible(true);
        }
        item.setLevel(this.getLevel() + 1);
        this.subItems.add(item);
    }

    public void setSubItemsVisible(boolean visible) {
        if (this.level == 0) {
            this.expandCollapse.setIcon((Component)new Icon(visible ? VaadinIcon.CARET_UP : VaadinIcon.CARET_DOWN));
        }
        this.subItems.forEach(item -> item.setVisible(visible));
        this.subItemsVisible = visible;
        this.updateAriaLabel();
    }

    public String getText() {
        return this.text;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.level == 0) {
                this.expandCollapse.setIcon((Component)new Icon(VaadinIcon.CARET_DOWN));
            }
        } else {
            this.setSubItemsVisible(visible);
        }
    }
}

