/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.components.navigation.drawer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.icon.VaadinIcon;
import coop.intergal.ui.components.navigation.drawer.NaviItem;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@CssImport(value="styles/components/navi-menu.css")
public class NaviMenu
extends Div {
    private String CLASS_NAME = "navi-menu";

    public NaviMenu() {
        this.setClassName(this.CLASS_NAME);
    }

    protected void addNaviItem(NaviItem item) {
        this.add(new Component[]{item});
    }

    protected void addNaviItem(NaviItem parent, NaviItem item) {
        parent.addSubItem(item);
        this.addNaviItem(item);
    }

    public void filter(String filter) {
        this.getNaviItems().forEach(naviItem -> {
            boolean matches = naviItem.getText().toLowerCase().contains(filter.toLowerCase());
            naviItem.setVisible(matches);
        });
    }

    public NaviItem addNaviItem(String text, Class<? extends Component> navigationTarget) {
        NaviItem item = new NaviItem(text, navigationTarget, null);
        this.addNaviItem(item);
        return item;
    }

    public NaviItem addNaviItem(VaadinIcon icon, String text, Class<? extends Component> navigationTarget) {
        NaviItem item = new NaviItem(icon, text, navigationTarget);
        this.addNaviItem(item);
        return item;
    }

    public NaviItem addNaviItem(Image image, String text, Class<? extends Component> navigationTarget) {
        NaviItem item = new NaviItem(image, text, navigationTarget);
        this.addNaviItem(item);
        return item;
    }

    public NaviItem addNaviItem(NaviItem parent, String text, Class<? extends Component> navigationTarget) {
        NaviItem item = new NaviItem(text, navigationTarget, null);
        this.addNaviItem(parent, item);
        return item;
    }

    public NaviItem addNaviItem(NaviItem parent, String text, Class<? extends Component> navigationTarget, Map<String, List<String>> parameters) {
        NaviItem item = new NaviItem(text, navigationTarget, parameters);
        this.addNaviItem(parent, item);
        return item;
    }

    public NaviItem addNaviItem(VaadinIcon icon, String text, Class<? extends Component> navigationTarget, Map<String, List<String>> parameters) {
        NaviItem item = new NaviItem(icon, text, navigationTarget, parameters);
        this.addNaviItem(item);
        return item;
    }

    public NaviItem addNaviItem(VaadinIcon icon, String text, Class<? extends Component> navigationTarget, String parameter) {
        NaviItem item = new NaviItem(icon, text, navigationTarget, parameter);
        this.addNaviItem(item);
        return item;
    }

    public List<NaviItem> getNaviItems() {
        List<NaviItem> items = this.getChildren().collect(Collectors.toList());
        return items;
    }
}

