/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.security;

import coop.intergal.ui.security.CustomRequestCache;
import coop.intergal.ui.security.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableWebSecurity
@Configuration
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final String LOGIN_PROCESSING_URL = "/login";
    private static final String LOGIN_FAILURE_URL = "/login?error";
    private static final String LOGIN_URL = "/login";
    private static final String LOGOUT_SUCCESS_URL = "/";
    @Value(value="${ldap.urls}")
    private String ldapUrls;
    @Value(value="${ldap.base.dn}")
    private String ldapBaseDn;
    @Value(value="${ldap.username}")
    private String ldapSecurityPrincipal;
    @Value(value="${ldap.password}")
    private String ldapPrincipalPassword;
    @Value(value="${ldap.user.dn.pattern}")
    private String ldapUserDnPattern;
    @Value(value="${ldap.enabled}")
    private String ldapEnabled;
    @Value(value="${security.enabled}")
    private String securityEnabled;
    @Autowired
    @Lazy
    private PasswordEncoder passwordEncoder;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        System.out.println("SecurityConfiguration.configure()----------------------------");
        if (Boolean.parseBoolean(this.ldapEnabled)) {
            auth.ldapAuthentication().groupSearchBase("ou=groups").userSearchFilter("uid={0}").contextSource().url(this.ldapUrls + LOGOUT_SUCCESS_URL + this.ldapBaseDn).managerDn(this.ldapSecurityPrincipal).managerPassword(this.ldapPrincipalPassword).and().passwordCompare().passwordEncoder((PasswordEncoder)new BCryptPasswordEncoder()).passwordAttribute("userPassword");
        } else {
            System.out.println("SecurityConfiguration.configure()---------------------------- .inMemoryAuthentication()");
            ((InMemoryUserDetailsManagerConfigurer)((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().withUser("user").password("$2y$12$kKMEWgLzpj/Dfg7LzJVXSOAQlzAa3TMCa8XCwuFhP2YOPICnAUHKe").roles(new String[]{"USER"}).and()).withUser("20user").password("$2y$12$kKMEWgLzpj/Dfg7LzJVXSOAQlzAa3TMCa8XCwuFhP2YOPICnAUHKe").roles(new String[]{"USER"}).and()).withUser("24user").password("$2y$12$kKMEWgLzpj/Dfg7LzJVXSOAQlzAa3TMCa8XCwuFhP2YOPICnAUHKe").roles(new String[]{"USER"});
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        if (!Boolean.parseBoolean(this.securityEnabled)) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().anyRequest()).permitAll().requestMatchers(new RequestMatcher[]{SecurityUtils::isFrameworkInternalRequest})).permitAll();
        } else {
            ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).requestCache().requestCache((RequestCache)new CustomRequestCache()).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{SecurityUtils::isFrameworkInternalRequest})).permitAll().anyRequest()).fullyAuthenticated().and()).formLogin().loginPage("/login").permitAll()).loginProcessingUrl("/login")).failureUrl(LOGIN_FAILURE_URL)).successHandler((AuthenticationSuccessHandler)new SavedRequestAwareAuthenticationSuccessHandler())).and()).logout().logoutSuccessUrl(LOGOUT_SUCCESS_URL);
        }
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/VAADIN/**", "/favicon.ico", "/robots.txt", "/manifest.webmanifest", "/sw.js", "/offline-page.html", "/icons/**", "/images/**", "/frontend/**", "/webjars/**", "/h2-console/**", "/frontend-es5/**", "/frontend-es6/**"});
    }
}

