/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.security;

import com.vaadin.flow.server.ServletHelper;
import coop.intergal.ui.security.data.CustomUser;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static String getUsername() {
        SecurityContext context = SecurityContextHolder.getContext();
        Object details = context.getAuthentication().getDetails();
        System.out.println("SecurityUtils.getUsername() details " + details.toString());
        Object principal = context.getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)context.getAuthentication().getPrincipal();
            return userDetails.getUsername();
        }
        return null;
    }

    public static String getFilterMyData() {
        SecurityContext context = SecurityContextHolder.getContext();
        Object principal = context.getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)context.getAuthentication().getPrincipal();
            return ((CustomUser)userDetails).getFilterMyData();
        }
        return null;
    }

    public static boolean isAccessGranted(Class<?> securedClass) {
        Authentication userAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (!SecurityUtils.isUserLoggedIn(userAuthentication)) {
            return false;
        }
        Secured secured = (Secured)AnnotationUtils.findAnnotation(securedClass, Secured.class);
        if (secured == null) {
            return true;
        }
        List<String> allowedRoles = Arrays.asList(secured.value());
        return userAuthentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(allowedRoles::contains);
    }

    public static boolean isUserLoggedIn() {
        return SecurityUtils.isUserLoggedIn(SecurityContextHolder.getContext().getAuthentication());
    }

    private static boolean isUserLoggedIn(Authentication authentication) {
        return authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
    }

    static boolean isFrameworkInternalRequest(HttpServletRequest request) {
        String parameterValue = request.getParameter("v-r");
        return parameterValue != null && Stream.of(ServletHelper.RequestType.values()).anyMatch(r -> r.getIdentifier().equals(parameterValue));
    }
}

