/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.security.data.entity;

import coop.intergal.ui.security.data.entity.AbstractEntity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity(name="UserInfo")
public class User
extends AbstractEntity {
    @NotEmpty
    @Email
    @Size(max=255)
    @Column(unique=true)
    private @NotEmpty @Email @Size(max=255) String email;
    @NotNull
    @Size(min=4, max=255)
    private @NotNull @Size(min=4, max=255) String passwordHash;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String firstName;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String lastName;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String role;
    private String filterMyData;
    private boolean locked = false;

    @PrePersist
    @PreUpdate
    private void prepareData() {
        this.email = this.email == null ? null : this.email.toLowerCase();
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getfilterMyData() {
        return this.filterMyData;
    }

    public void setfilterMyData(String filterMyData) {
        this.filterMyData = filterMyData;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }
}

