/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.security.ldap;

import coop.intergal.espresso.presutec.utils.JSonClient;
import coop.intergal.ui.security.ldap.LdapConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

@Configuration
@PropertySource(value={"classpath:application.properties"})
public class LdapClient {
    @Value(value="${ldap.urls}")
    private static String ldapUrls;
    @Value(value="${ldap.base.dn}")
    private static String ldapBaseDn;
    @Value(value="${ldap.username}")
    private static String ldapSecurityPrincipal;
    @Value(value="${ldap.password}")
    private static String ldapPrincipalPassword;
    private static String uidOu;
    private static LdapConnection ldapConnection;
    @Value(value="${ldap.user.dn.pattern}")
    private String ldapUserDnPattern;
    @Value(value="${ldap.enabled}")
    private String ldapEnabled;
    private static final String MEMBER_OF = "memberOf";
    private static final String[] attrIdsToSearch;
    public static final String SEARCH_BY_SAM_ACCOUNT_NAME = "(uid=%s)";
    public static final String SEARCH_GROUP_BY_GROUP_CN = "(&(objectCategory=group)(cn={0}))";

    @Bean
    public LdapConnection getDBConnection() {
        LdapConnection ldapConnection = new LdapConnection();
        return ldapConnection;
    }

    private void removeLDAPObject(DirContext context, String name) throws NamingException {
        context.destroySubcontext(name);
    }

    public static void createLDAPUser(String name, String password, Hashtable<String, String> fieldsAndData, String snvalue, String cnvalue) throws NamingException {
        DirContext context = LdapClient.getContext();
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute attribute = new BasicAttribute("objectClass");
        attribute.add("inetOrgPerson");
        attribute.add("organizationalPerson");
        attribute.add("person");
        attribute.add("top");
        attributes.put(attribute);
        BasicAttribute sn = new BasicAttribute("sn");
        sn.add(snvalue);
        attributes.put(sn);
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add(cnvalue);
        attributes.put(cn);
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        userPassword.add(encoder.encode((CharSequence)password));
        attributes.put(userPassword);
        if (fieldsAndData != null) {
            Enumeration<String> fieldsAndDataELE = fieldsAndData.keys();
            while (fieldsAndDataELE.hasMoreElements()) {
                String field = fieldsAndDataELE.nextElement();
                String data = fieldsAndData.get(field);
                attributes.put(field, data);
            }
        }
        context.createSubcontext(name, (Attributes)attributes);
    }

    public static String changePassword(String name, String oldPass, String newPass, Boolean force, Boolean externoSN) throws NamingException, UnsupportedEncodingException {
        DirContext context = externoSN == true ? LdapClient.getContextExterno() : LdapClient.getContext();
        ModificationItem[] mods = new ModificationItem[1];
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        Attributes attrs = context.getAttributes(name);
        byte[] v = (byte[])attrs.get("userPassword").get();
        String saveOldPass = new String(v);
        BasicAttribute oldUserPassword = new BasicAttribute("userPassword");
        boolean isSavedPass = encoder.matches((CharSequence)oldPass, saveOldPass);
        if (isSavedPass || force.booleanValue()) {
            oldUserPassword.add(encoder.encode((CharSequence)newPass));
            mods[0] = new ModificationItem(2, oldUserPassword);
            context.modifyAttributes(name, mods);
            return "OK";
        }
        return "WRONG OLD PASSWORD";
    }

    private void removeAttribute(DirContext context, String name, String attrName) throws NamingException {
        BasicAttribute attribute = new BasicAttribute(attrName);
        ModificationItem[] item = new ModificationItem[]{new ModificationItem(3, attribute)};
        context.modifyAttributes(name, item);
    }

    private void createAttribute(DirContext context, String name, String attrName, Object attrValue) throws NamingException {
        BasicAttribute attribute = new BasicAttribute(attrName, attrValue);
        ModificationItem[] item = new ModificationItem[]{new ModificationItem(1, attribute)};
        context.modifyAttributes(name, item);
    }

    private void updateAttribute(DirContext context, String name, String attrName, Object attrValue) throws NamingException {
        BasicAttribute attribute = new BasicAttribute(attrName, attrValue);
        ModificationItem[] item = new ModificationItem[]{new ModificationItem(2, attribute)};
        context.modifyAttributes(name, item);
    }

    public static void viewAttribute(String attrName) throws NamingException {
        DirContext context = LdapClient.getContext();
        Attributes attrs = context.getAttributes(uidOu);
        if (attrs.get(attrName) == null) {
            System.out.println(attrName + " **** NO EXISTE **** ");
        } else {
            System.out.println(attrName + ":" + attrs.get(attrName).get());
        }
    }

    public static String getAttributeValue(String attrName) throws NamingException {
        DirContext context = LdapClient.getContext();
        Attributes attrs = context.getAttributes(uidOu);
        if (attrs.get(attrName) == null) {
            System.out.println(attrName + " **** NO EXISTE **** ");
            return null;
        }
        String value = (String)attrs.get(attrName).get();
        System.out.println(attrName + ":" + value);
        return value;
    }

    public static boolean isMemberOf(String[] roles) throws NamingException {
        DirContext context = LdapClient.getContext();
        ldapBaseDn = ldapConnection.getLdapBaseDn();
        String filter = String.format(SEARCH_BY_SAM_ACCOUNT_NAME, LdapClient.getUid(uidOu));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setReturningAttributes(attrIdsToSearch);
        NamingEnumeration<SearchResult> results = context.search("", filter, constraints);
        if (results == null || !results.hasMore()) {
            System.out.println("No result found");
            return false;
        }
        SearchResult result = results.next();
        result.getName();
        NameParser parser = context.getNameParser("");
        Name contextName = parser.parse(context.getNameInNamespace());
        Name baseName = parser.parse(ldapBaseDn);
        Name entryName = parser.parse(new CompositeName(result.getName()).get(0));
        Attributes attrs = result.getAttributes();
        Attribute attr = attrs.get(attrIdsToSearch[0]);
        if (attr != null) {
            NamingEnumeration<?> e = attr.getAll();
            System.out.println("Member of");
            while (e.hasMore()) {
                String value = (String)e.next();
                for (int i = 0; i < roles.length; ++i) {
                    if (value.indexOf("cn=" + roles[i]) <= -1) continue;
                    return true;
                }
                System.out.println(value);
            }
        }
        return false;
    }

    public static boolean isMemberOfOu(String ou) throws NamingException {
        LdapClient.viewAttribute("cn");
        DirContext context = LdapClient.getContext();
        ldapBaseDn = ldapConnection.getLdapBaseDn();
        String filter = String.format(SEARCH_BY_SAM_ACCOUNT_NAME, LdapClient.getUid(uidOu));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setReturningAttributes(attrIdsToSearch);
        NamingEnumeration<SearchResult> results = context.search("", filter, constraints);
        if (results == null || !results.hasMore()) {
            System.out.println("No result found");
            return false;
        }
        SearchResult result = results.next();
        String name = result.getName();
        return name.indexOf("ou=" + ou) != -1;
    }

    private static Object getUid(String uidOu) {
        int idxStart = uidOu.indexOf("uid=") + 4;
        int idxEnd = uidOu.indexOf(",");
        return uidOu.substring(idxStart, idxEnd);
    }

    public static DirContext getContext() throws NamingException {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context.getAuthentication() != null) {
            Object details = context.getAuthentication().getDetails();
            System.out.println("SecurityUtils.getUsername() details " + details.toString());
            LdapUserDetails principal = (LdapUserDetails)context.getAuthentication().getPrincipal();
            if (principal instanceof LdapUserDetails) {
                String dn = principal.getDn();
                uidOu = LdapClient.getUidOu(dn);
            }
        }
        AnnotationConfigApplicationContext anotContext = new AnnotationConfigApplicationContext();
        anotContext.scan(new String[]{"coop.intergal.ui.security"});
        anotContext.refresh();
        System.out.println("Refreshing the spring context");
        ldapConnection = (LdapConnection)anotContext.getBean(LdapConnection.class);
        DirContext ldpaContex = null;
        anotContext.close();
        try {
            ldpaContex = ldapConnection.getContext();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return ldpaContex;
    }

    private static DirContext getContextExterno() throws NamingException {
        Properties properties = new Properties();
        LdapClient.cargaProperties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", ldapUrls);
        properties.put("java.naming.security.credentials", ldapPrincipalPassword);
        properties.put("java.naming.security.principal", ldapSecurityPrincipal);
        return new InitialDirContext(properties);
    }

    private static void cargaProperties() {
        InputStream is = JSonClient.class.getResourceAsStream("/application.properties");
        Properties prop = new Properties();
        try {
            prop.load(is);
            ldapUrls = prop.getProperty("ldap.urls");
            ldapPrincipalPassword = prop.getProperty("ldap.password");
            ldapSecurityPrincipal = prop.getProperty("ldap.username");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getUidOu(String dn) {
        int idxEnd = dn.indexOf(",dc=");
        if (idxEnd > -1) {
            return dn.substring(0, idxEnd);
        }
        return dn;
    }

    public static boolean userHasAnyOfThisTypes(String[] typesToCheck) {
        try {
            DirContext context = LdapClient.getContext();
            Attributes attrs = context.getAttributes(uidOu);
            if (attrs.get("employeeType") == null) {
                System.out.println("employeeType  **** NO EXISTE **** ");
            } else {
                String employeeType = (String)attrs.get("employeeType").get();
                String[] typesEmployee = employeeType.split(Pattern.quote(","));
                System.out.println("employeeType :" + attrs.get("employeeType").get());
                for (int i = 0; typesToCheck.length > i; ++i) {
                    for (int ii = 0; typesEmployee.length > ii; ++ii) {
                        if (!typesToCheck[i].equals(typesEmployee[ii])) continue;
                        return true;
                    }
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return false;
    }

    static {
        attrIdsToSearch = new String[]{MEMBER_OF, "displayName"};
    }
}

