/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.security.ldap;

import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.springframework.beans.factory.annotation.Value;

public class LdapConnection {
    @Value(value="${ldap.urls}")
    private String ldapUrls;
    @Value(value="${ldap.base.dn}")
    private String ldapBaseDn;
    @Value(value="${ldap.username}")
    private String ldapSecurityPrincipal;
    @Value(value="${ldap.password}")
    private String ldapPrincipalPassword;
    @Value(value="${ldap.user.dn.pattern}")
    private String ldapUserDnPattern;
    @Value(value="${ldap.enabled}")
    private String ldapEnabled;

    public String getLdapBaseDn() {
        return this.ldapBaseDn;
    }

    public DirContext getContext() throws NamingException {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", this.ldapUrls + "/" + this.ldapBaseDn);
        properties.put("java.naming.security.credentials", this.ldapPrincipalPassword);
        properties.put("java.naming.security.principal", this.ldapSecurityPrincipal);
        return new InitialDirContext(properties);
    }
}

