/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.util;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import coop.intergal.ui.components.FlexBoxLayout;
import coop.intergal.ui.layout.size.Right;
import coop.intergal.ui.util.FontSize;
import coop.intergal.ui.util.FontWeight;
import coop.intergal.ui.util.IconSize;
import coop.intergal.ui.util.LineHeight;
import coop.intergal.ui.util.TextColor;
import coop.intergal.ui.util.css.AlignSelf;
import coop.intergal.ui.util.css.BorderRadius;
import coop.intergal.ui.util.css.BoxSizing;
import coop.intergal.ui.util.css.Overflow;
import coop.intergal.ui.util.css.PointerEvents;
import coop.intergal.ui.util.css.Shadow;
import coop.intergal.ui.util.css.TextAlign;
import coop.intergal.ui.util.css.TextOverflow;
import coop.intergal.ui.util.css.WhiteSpace;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class UIUtils {
    public static final String IMG_PATH = "images/";
    private static final ThreadLocal<DecimalFormat> decimalFormat = ThreadLocal.withInitial(() -> new DecimalFormat("###,###,###.00"));
    private static final ThreadLocal<DateTimeFormatter> dateFormat = ThreadLocal.withInitial(() -> DateTimeFormatter.ofPattern("MMM dd, YYYY"));

    public static Button createPrimaryButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createPrimaryButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createPrimaryButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createTertiaryButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_TERTIARY);
    }

    public static Button createTertiaryButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_TERTIARY);
    }

    public static Button createTertiaryButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_TERTIARY);
    }

    public static Button createTertiaryInlineButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_TERTIARY_INLINE);
    }

    public static Button createTertiaryInlineButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_TERTIARY_INLINE);
    }

    public static Button createTertiaryInlineButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_TERTIARY_INLINE);
    }

    public static Button createSuccessButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_SUCCESS);
    }

    public static Button createSuccessButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_SUCCESS);
    }

    public static Button createSuccessButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_SUCCESS);
    }

    public static Button createSuccessPrimaryButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_SUCCESS, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createSuccessPrimaryButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_SUCCESS, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createSuccessPrimaryButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_SUCCESS, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createErrorButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_ERROR);
    }

    public static Button createErrorButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_ERROR);
    }

    public static Button createErrorButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_ERROR);
    }

    public static Button createErrorPrimaryButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_ERROR, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createErrorPrimaryButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_ERROR, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createErrorPrimaryButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_ERROR, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createContrastButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_CONTRAST);
    }

    public static Button createContrastButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_CONTRAST);
    }

    public static Button createContrastButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_CONTRAST);
    }

    public static Button createContrastPrimaryButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_CONTRAST, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createContrastPrimaryButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_CONTRAST, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createContrastPrimaryButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_CONTRAST, ButtonVariant.LUMO_PRIMARY);
    }

    public static Button createSmallButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_SMALL);
    }

    public static Button createSmallButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_SMALL);
    }

    public static Button createSmallButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_SMALL);
    }

    public static Button createLargeButton(String text) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), ButtonVariant.LUMO_LARGE);
    }

    public static Button createLargeButton(VaadinIcon icon) {
        return UIUtils.createButton(icon, ButtonVariant.LUMO_LARGE);
    }

    public static Button createLargeButton(String text, VaadinIcon icon) {
        return UIUtils.createButton(UIUtils.cleanMarks(text), icon, ButtonVariant.LUMO_LARGE);
    }

    public static Button createButton(String text, ButtonVariant ... variants) {
        Button button = new Button(UIUtils.cleanMarks(text));
        button.addThemeVariants(variants);
        button.getElement().setAttribute("aria-label", text);
        return button;
    }

    public static Button createButton(VaadinIcon icon, ButtonVariant ... variants) {
        Button button = new Button((Component)new Icon(icon));
        button.addThemeVariants(variants);
        return button;
    }

    public static Button createButton(String text, VaadinIcon icon, ButtonVariant ... variants) {
        Icon i = new Icon(icon);
        i.getElement().setAttribute("slot", "prefix");
        Button button = new Button(UIUtils.cleanMarks(text), (Component)i);
        button.addThemeVariants(variants);
        return button;
    }

    public static TextField createSmallTextField() {
        TextField textField = new TextField();
        textField.addThemeVariants(new TextFieldVariant[]{TextFieldVariant.LUMO_SMALL});
        return textField;
    }

    public static Label createLabel(FontSize size, TextColor color, String text) {
        Label label = new Label(text);
        UIUtils.setFontSize(size, new Component[]{label});
        UIUtils.setTextColor(color, new Component[]{label});
        return label;
    }

    public static Label createLabel(FontSize size, String text) {
        return UIUtils.createLabel(size, TextColor.BODY, text);
    }

    public static Label createLabel(TextColor color, String text) {
        return UIUtils.createLabel(FontSize.M, color, text);
    }

    public static Label createH1Label(String text) {
        Label label = new Label(text);
        label.addClassName("h1");
        return label;
    }

    public static Label createH2Label(String text) {
        Label label = new Label(text);
        label.addClassName("h2");
        return label;
    }

    public static Label createH3Label(String text) {
        Label label = new Label(text);
        label.addClassName("h3");
        return label;
    }

    public static Label createH4Label(String text) {
        Label label = new Label(text);
        label.addClassName("h4");
        return label;
    }

    public static Label createH5Label(String text) {
        Label label = new Label(text);
        label.addClassName("h5");
        return label;
    }

    public static Label createH6Label(String text) {
        Label label = new Label(text);
        label.addClassName("h6");
        return label;
    }

    public static Button createFloatingActionButton(VaadinIcon icon) {
        Button button = UIUtils.createPrimaryButton(icon);
        button.addThemeName("fab");
        return button;
    }

    public static FlexLayout createPhoneLayout() {
        TextField prefix = new TextField();
        prefix.setValue("+358");
        prefix.setWidth("80px");
        TextField number = new TextField();
        number.setValue("999999999");
        FlexBoxLayout layout = new FlexBoxLayout(new Component[]{prefix, number});
        layout.setFlexGrow(1.0, new HasElement[]{number});
        layout.setSpacing(Right.S);
        return layout;
    }

    public static String formatAmount(Double amount) {
        return decimalFormat.get().format(amount);
    }

    public static String formatAmount(int amount) {
        return decimalFormat.get().format(amount);
    }

    public static Label createAmountLabel(double amount) {
        Label label = UIUtils.createH5Label(UIUtils.formatAmount(amount));
        label.addClassName("monospace");
        return label;
    }

    public static String formatUnits(int units) {
        return NumberFormat.getIntegerInstance().format(units);
    }

    public static Label createUnitsLabel(int units) {
        Label label = new Label(UIUtils.formatUnits(units));
        label.addClassName("monospace");
        return label;
    }

    public static Icon createPrimaryIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor(TextColor.PRIMARY, new Component[]{i});
        return i;
    }

    public static Icon createSecondaryIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor(TextColor.SECONDARY, new Component[]{i});
        return i;
    }

    public static Icon createTertiaryIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor(TextColor.TERTIARY, new Component[]{i});
        return i;
    }

    public static Icon createDisabledIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor(TextColor.DISABLED, new Component[]{i});
        return i;
    }

    public static Icon createSuccessIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor(TextColor.SUCCESS, new Component[]{i});
        return i;
    }

    public static Icon createErrorIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        UIUtils.setTextColor(TextColor.ERROR, new Component[]{i});
        return i;
    }

    public static Icon createSmallIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        i.addClassName(IconSize.S.getClassName());
        return i;
    }

    public static Icon createLargeIcon(VaadinIcon icon) {
        Icon i = new Icon(icon);
        i.addClassName(IconSize.L.getClassName());
        return i;
    }

    public static Icon createIcon(IconSize size, TextColor color, VaadinIcon icon) {
        Icon i = new Icon(icon);
        i.addClassNames(new String[]{size.getClassName()});
        UIUtils.setTextColor(color, new Component[]{i});
        return i;
    }

    public static String formatDate(LocalDate date) {
        return dateFormat.get().format(date);
    }

    public static void showNotification(String text) {
        Notification.show((String)text, (int)3000, (Notification.Position)Notification.Position.BOTTOM_CENTER);
    }

    public static void setAlignSelf(AlignSelf alignSelf, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("align-self", alignSelf.getValue());
        }
    }

    public static void setBackgroundColor(String backgroundColor, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("background-color", backgroundColor);
        }
    }

    public static void setBorderRadius(BorderRadius borderRadius, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("border-radius", borderRadius.getValue());
        }
    }

    public static void setBoxSizing(BoxSizing boxSizing, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("box-sizing", boxSizing.getValue());
        }
    }

    public static void setColSpan(int span, Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("colspan", Integer.toString(span));
        }
    }

    public static void setFontSize(FontSize fontSize, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("font-size", fontSize.getValue());
        }
    }

    public static void setFontWeight(FontWeight fontWeight, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("font-weight", fontWeight.getValue());
        }
    }

    public static void setLineHeight(LineHeight lineHeight, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("line-height", lineHeight.getValue());
        }
    }

    public static void setLineHeight(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("line-height", value);
        }
    }

    public static void setMaxWidth(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("max-width", value);
        }
    }

    public static void setOverflow(Overflow overflow, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("overflow", overflow.getValue());
        }
    }

    public static void setPointerEvents(PointerEvents pointerEvents, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("pointer-events", pointerEvents.getValue());
        }
    }

    public static void setShadow(Shadow shadow, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("box-shadow", shadow.getValue());
        }
    }

    public static void setTextAlign(TextAlign textAlign, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("text-align", textAlign.getValue());
        }
    }

    public static void setTextColor(TextColor textColor, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("color", textColor.getValue());
        }
    }

    public static void setTextOverflow(TextOverflow textOverflow, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("text-overflow", textOverflow.getValue());
        }
    }

    public static void setTheme(String theme, Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("theme", theme);
        }
    }

    public static void setTooltip(String tooltip, Component ... components) {
        for (Component component : components) {
            component.getElement().setProperty("title", tooltip);
        }
    }

    public static void setWhiteSpace(WhiteSpace whiteSpace, Component ... components) {
        for (Component component : components) {
            component.getElement().setProperty("white-space", whiteSpace.getValue());
        }
    }

    public static void setWidth(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().getStyle().set("width", value);
        }
    }

    public static void setAriaLabel(String value, Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("aria-label", value);
        }
    }

    private static String cleanMarks(String label) {
        int idxMarkIDM = label.indexOf("@");
        if (idxMarkIDM > -1) {
            return label.substring(0, idxMarkIDM);
        }
        return label;
    }
}

