/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.util;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import coop.intergal.ui.security.SecurityUtils;
import coop.intergal.ui.security.ldap.LdapClient;
import coop.intergal.ui.views.DynamicQryGridDisplay;
import coop.intergal.vaadin.rest.utils.RestData;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.naming.NamingException;

public class UtilSessionData {
    public static boolean getCache() {
        Object cacheStr = VaadinSession.getCurrent().getAttribute("cache");
        boolean cache = true;
        if (cacheStr != null && cacheStr.equals("false")) {
            cache = false;
        }
        return cache;
    }

    public static void setCache(String cache) {
        VaadinSession.getCurrent().setAttribute("cache", (Object)cache);
        System.out.println("UtilSessionData.setCache() ->" + cache);
    }

    public static String getFormParams(String key) {
        String actualFormParams = (String)VaadinSession.getCurrent().getAttribute("formParams");
        if (actualFormParams == null) {
            return null;
        }
        if (key.equals("ALL")) {
            return actualFormParams;
        }
        if (actualFormParams.indexOf(key) == -1) {
            return null;
        }
        int idxStart = actualFormParams.indexOf(key) + key.length() + 1;
        int idxEnd = idxStart + actualFormParams.substring(idxStart).indexOf("#");
        return actualFormParams.substring(idxStart, idxEnd);
    }

    public static void setFormParams(String key, String formParams) {
        String actualFormParams = UtilSessionData.getFormParams("ALL");
        if (actualFormParams != null && actualFormParams.indexOf(key) > -1) {
            int idxStart = actualFormParams.indexOf(key) + key.length() + 1;
            int idxEnd = idxStart + actualFormParams.substring(idxStart).indexOf("#");
            actualFormParams = actualFormParams.substring(0, idxStart) + formParams + actualFormParams.substring(idxEnd);
        } else {
            actualFormParams = actualFormParams != null ? actualFormParams + key + "=" + formParams + "#" : key + "=" + formParams + "#";
        }
        VaadinSession.getCurrent().setAttribute("formParams", (Object)actualFormParams);
        System.out.println("UtilSessionData.setformParams() ->" + actualFormParams);
    }

    public static String getCompanyYear() {
        Object companyYear = VaadinSession.getCurrent().getAttribute("companyYear");
        System.out.println("UtilSessionData.getCompanyYear() ->" + companyYear);
        if (companyYear == null) {
            companyYear = "";
        }
        return (String)companyYear;
    }

    public static void setCompanyYear(String companyYear) {
        VaadinSession.getCurrent().setAttribute("companyYear", (Object)companyYear);
        System.out.println("UtilSessionData.setCompanyYear() ->" + companyYear);
    }

    public static String getCompany() {
        Object company = VaadinSession.getCurrent().getAttribute("company");
        System.out.println("UtilSessionData.getCompany() ->" + company);
        if (company == null) {
            company = "";
        }
        return (String)company;
    }

    public static void setCompany(String company) {
        VaadinSession.getCurrent().setAttribute("company", (Object)company);
        System.out.println("UtilSessionData.setCompany() ->" + company);
    }

    public static String getCompanies() {
        Object companies = VaadinSession.getCurrent().getAttribute("companies");
        System.out.println("UtilSessionData.getCompanies() ->" + companies);
        if (companies == null) {
            companies = "";
        }
        return (String)companies;
    }

    public static void setCompanies(String companies) {
        VaadinSession.getCurrent().setAttribute("companies", (Object)companies);
        System.out.println("UtilSessionData.setCompanies() ->" + companies);
    }

    public static boolean isVisibleOrEditableByTag(String tagsForVisibility) {
        if (tagsForVisibility == null || tagsForVisibility.isEmpty()) {
            return true;
        }
        StringTokenizer tokens = new StringTokenizer(tagsForVisibility, ",");
        boolean i = false;
        while (tokens.hasMoreTokens()) {
            String tag = tokens.nextToken();
            int idxColon = tag.indexOf(":");
            if (idxColon == -1) {
                System.out.println("UtilSessionData.isVisibleOrEditableByTag() ERROR tag mal definido , user key:value, por ejemplo company:TYSH");
                return false;
            }
            String tagKey = tag.substring(0, idxColon);
            boolean trueOrFalse = true;
            if (tagKey.indexOf("!") != -1) {
                trueOrFalse = false;
                tagKey = tag.substring(0, idxColon - 1);
            }
            String tagValue = tag.substring(idxColon + 1);
            String keyValue = UtilSessionData.getKeyValue(tagKey);
            if (tagKey.startsWith("ldap.")) {
                String[] typesTag = tagValue.split(Pattern.quote(","));
                return UtilSessionData.userHasTypes(typesTag);
            }
            if (keyValue == null || !keyValue.equals(tagValue)) continue;
            return trueOrFalse;
        }
        return false;
    }

    public static String getKeyValue(String tagkey) {
        if ("company;user;row;ldap".indexOf(tagkey) == -1) {
            System.out.println("tag not in TAGS_LIST");
        }
        if (tagkey.equals("user")) {
            return SecurityUtils.getUsername();
        }
        if (tagkey.startsWith("user.")) {
            return UtilSessionData.getValueFromTableUser(tagkey);
        }
        if (tagkey.startsWith("ldap.")) {
            return UtilSessionData.getValueFromLdap(tagkey);
        }
        return (String)VaadinSession.getCurrent().getAttribute(tagkey);
    }

    private static String getValueFromLdap(String tagkey) {
        try {
            return LdapClient.getAttributeValue(tagkey.substring(tagkey.indexOf(".") + 1));
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getValueFromTableUser(String tagkey, String appConst) {
        String field = tagkey.substring(tagkey.indexOf(".") + 1);
        String filter = "lOGIN='<<user>>'".replace("<<user>>", SecurityUtils.getUsername());
        return RestData.getDataValueFromAFieldOfAResource("FISCALEURO:USUARIOS", field, filter, appConst).asText();
    }

    public static String getValueFromTableUser(String tagkey) {
        return UtilSessionData.getValueFromTableUser(tagkey, UtilSessionData.getCompanyYear() + "TYSLac0");
    }

    public static String addCompanyToTitle(String optionName) {
        String title = optionName + " (" + UtilSessionData.getCompanyYear() + ")";
        return title;
    }

    public static Component getOpenUI(String idMenu) {
        for (UI uI : VaadinSession.getCurrent().getUIs()) {
            Iterator components = uI.getChildren().iterator();
            while (components.hasNext()) {
                Component comp = (Component)components.next();
                if (!(comp instanceof DynamicQryGridDisplay)) continue;
                DynamicQryGridDisplay dQGD = (DynamicQryGridDisplay)comp;
                System.out.println("UtilSessionData. comp " + dQGD.getPageTitle());
                if (dQGD.getIdMenu() == null || !dQGD.getIdMenu().equals(idMenu)) continue;
                return dQGD;
            }
        }
        return null;
    }

    public static boolean userHasRole(String Role2) {
        try {
            boolean hasRoles = LdapClient.isMemberOf(new String[]{Role2});
            System.out.println("HAS ROLE ADMIN " + hasRoles);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean userHasTypes(String[] types) {
        boolean hasRoles = LdapClient.userHasAnyOfThisTypes(types);
        System.out.println("HAS ROLE ADMIN " + hasRoles);
        return hasRoles;
    }

    public static boolean userIsMemberOfOU(String ou) {
        boolean belongsToOU = false;
        try {
            belongsToOU = LdapClient.isMemberOfOu(ou);
            System.out.println(" " + belongsToOU);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return belongsToOU;
    }
}

