/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.utils;

import coop.intergal.AppConstGeneric;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;

public class FormattingUtils {
    public static final String DECIMAL_ZERO = "0.00";
    public static final DateTimeFormatter MONTH_AND_DAY_FORMATTER = DateTimeFormatter.ofPattern("MMM d", AppConstGeneric.APP_LOCALE);
    public static final DateTimeFormatter WEEKDAY_FULLNAME_FORMATTER = DateTimeFormatter.ofPattern("EEEE", AppConstGeneric.APP_LOCALE);
    public static final TemporalField WEEK_OF_YEAR_FIELD = WeekFields.of(AppConstGeneric.APP_LOCALE).weekOfWeekBasedYear();
    public static final DateTimeFormatter SHORT_DAY_FORMATTER = DateTimeFormatter.ofPattern("E d", AppConstGeneric.APP_LOCALE);
    public static final DateTimeFormatter FULL_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy", AppConstGeneric.APP_LOCALE);
    public static final DateTimeFormatter HOUR_FORMATTER = DateTimeFormatter.ofPattern("h:mm a", AppConstGeneric.APP_LOCALE);

    public static String getFullMonthName(LocalDate date) {
        return date.getMonth().getDisplayName(TextStyle.FULL, AppConstGeneric.APP_LOCALE);
    }

    public static String formatAsCurrency(int valueInCents) {
        return NumberFormat.getCurrencyInstance(AppConstGeneric.APP_LOCALE).format(BigDecimal.valueOf(valueInCents, 2));
    }

    public static String formatAs2Decimal(BigInteger valueInCents) {
        String value = valueInCents + "";
        int length = value.length();
        if (length < 2) {
            return "0";
        }
        int nDecimals = new Integer(value.substring(length - 2));
        int posiComma = (value = value.substring(0, length - 2)).length() - nDecimals;
        if (posiComma == 0) {
            return "0," + value;
        }
        if (posiComma < 0) {
            String nCeros = new String(new char[posiComma * -1]).replace("\u0000", "0");
            return "0," + nCeros + value;
        }
        String afterComma = value.substring(posiComma);
        String beforeComma = value.substring(0, posiComma);
        NumberFormat nf = NumberFormat.getNumberInstance(AppConstGeneric.APP_LOCALE);
        DecimalFormat df = (DecimalFormat)nf;
        String nCeros = new String(new char[nDecimals]).replace("\u0000", "0");
        df.applyPattern("###,###." + nCeros);
        String output = df.format(Double.valueOf(beforeComma + "." + afterComma));
        return output;
    }

    public static DecimalFormat getUiPriceFormatter() {
        DecimalFormat formatter = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(AppConstGeneric.APP_LOCALE));
        formatter.setGroupingUsed(false);
        return formatter;
    }
}

