/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.flow.component.UI;
import coop.intergal.espresso.presutec.utils.JSonClient;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TranslateResource {
    public static String getFieldLocale(String field) {
        return TranslateResource.getFieldLocale(field, null);
    }

    public static String getFieldLocale(String field, String tableName) {
        String clave = field;
        Locale locale = UI.getCurrent().getLocale();
        try {
            ResourceBundle labels = ResourceBundle.getBundle("ResourceBundle", locale);
            if (labels != null && field != null) {
                clave = labels.getString(field);
            }
        }
        catch (MissingResourceException e) {
            try {
                ResourceBundle labels = ResourceBundle.getBundle("ResourceBundle", new Locale("es", "ES"));
                clave = labels.getString(field);
            }
            catch (MissingResourceException e2) {
                return clave;
            }
        }
        return clave;
    }

    private static String getClaveFromFieldTemplate(String field, String tableName) {
        try {
            JsonNode rowsFT;
            String filtro = "fieldName='" + field + "'";
            if (tableName != null) {
                if (tableName.startsWith("CHAIN:")) {
                    tableName = tableName.substring(6);
                }
                filtro = filtro + "%20AND%20tableName='" + tableName + "'";
            }
            if ((rowsFT = JSonClient.get("FieldTemplate", filtro, true, "metadataLac0", "10")) != null && rowsFT.get("errorMessage") == null && rowsFT.size() > 0) {
                return rowsFT.get(0).get("question").asText();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return field;
    }
}

