/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.utils.converters;

import com.vaadin.flow.templatemodel.ModelEncoder;
import coop.intergal.ui.dataproviders.DataProviderUtil;
import coop.intergal.ui.utils.FormattingUtils;
import java.math.BigInteger;

public class DecimalFormatter
implements ModelEncoder<BigInteger, String> {
    private static final long serialVersionUID = 1L;

    public String encode(BigInteger modelValue) {
        return DataProviderUtil.convertIfNotNull(modelValue, FormattingUtils::formatAs2Decimal);
    }

    public BigInteger decode(String presentationValue) {
        throw new UnsupportedOperationException();
    }

    public BigInteger getCents(String col, int nDecimals) {
        if (col == null || col.equals("null") || col.equals("")) {
            return null;
        }
        col = col.replace(",", ".");
        col = String.format("%." + nDecimals + "f", Double.valueOf(col));
        int idxE = (col = col.replace(",", ".")).indexOf("\u20ac");
        if (idxE > -1) {
            col = col.substring(0, idxE - 1);
        }
        String cents = col;
        int idXOfPoint = col.indexOf(".");
        if (nDecimals == 0) {
            return new BigInteger(cents + "00");
        }
        if (idXOfPoint == -1) {
            cents = cents + "00";
        } else if (idXOfPoint == col.length() - 2) {
            cents = col.substring(0, col.indexOf(".")) + col.substring(col.indexOf(".") + 1) + "0";
        } else if (idXOfPoint > -1) {
            cents = col.substring(0, col.indexOf(".")) + col.substring(col.indexOf(".") + 1);
        }
        String nDecimalsStr = "0";
        nDecimalsStr = nDecimals < 10 ? nDecimalsStr + nDecimals : nDecimals + "";
        cents = cents + nDecimalsStr;
        return new BigInteger(cents);
    }
}

