/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.views;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.templatemodel.TemplateModel;
import coop.intergal.ui.components.FormButtonsBar;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.ui.views.DynamicViewGrid;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Tag(value="dynamic-grid-display")
@JsModule(value="./src/views/generic/layout/dynamic-grid-display.js")
@CssImport.Container(value={@CssImport(value="./styles/tysstyle.css", themeFor="dynamic-grid-display"), @CssImport(value="./styles/tysstyle-form-layout.css", themeFor="vaadin-form-layout")})
public class DynamicGridDisplay
extends PolymerTemplate<TemplateModel>
implements BeforeEnterObserver,
HasDynamicTitle {
    private ArrayList<String> rowsColList;
    private static final long serialVersionUID = 1L;
    @Id(value="grid")
    private DynamicViewGrid grid;
    @Id(value="divDisplay")
    private Div divDisplay;
    @Id(value="divSubGrid")
    private Div divSubGrid;
    private Binder<DynamicDBean> binder = new Binder(DynamicDBean.class);
    private DdbDataBackEndProvider dataProvider;
    private DynamicDBean bean;
    private String extraFilterToSelect;
    private String resourceName;
    private String title;
    private String filter;
    @Id(value="buttons")
    private FormButtonsBar buttons;
    private String apiname;
    private boolean cache = true;
    private String queryFormClassName;
    private String displayFormClassName;
    @Id(value="displaySplitSubGrid")
    private SplitLayout displaySplitSubGrid;
    private String gridClassName;
    @Id(value="gridSplitDisplay")
    private SplitLayout gridSplitDisplay;

    public ArrayList<String> getRowsColList() {
        return this.rowsColList;
    }

    public void setRowsColList(ArrayList<String> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public DynamicGridDisplay() {
        this.setId("DGD");
    }

    public DynamicGridDisplay(TemplateParser parser, VaadinService service) {
        super(parser, service);
    }

    public DynamicGridDisplay(TemplateParser parser) {
        super(parser);
    }

    public DynamicDBean getBean() {
        return this.bean;
    }

    public void setBean(DynamicDBean bean) {
        this.bean = bean;
    }

    public DdbDataBackEndProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DdbDataBackEndProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public String getExtraFilterToSelect() {
        return this.extraFilterToSelect;
    }

    public void setExtraFilterToSelect(String extraFilterToSelect) {
        this.extraFilterToSelect = extraFilterToSelect;
    }

    public String getQueryFormClassName() {
        return this.queryFormClassName;
    }

    public void setQueryFormClassName(String queryFormClassName) {
        this.queryFormClassName = queryFormClassName;
    }

    public SplitLayout getDisplaySplitSubGrid() {
        return this.displaySplitSubGrid;
    }

    public void setDisplaySplitSubGrid(SplitLayout displaySplitSubGrid) {
        this.displaySplitSubGrid = displaySplitSubGrid;
    }

    protected String getBasePage() {
        return "products";
    }

    protected Binder<DynamicDBean> getBinder() {
        return this.binder;
    }

    public void setBinder(Binder<DynamicDBean> binder) {
        this.binder = binder;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Button showButtonClickedMessage() {
        return null;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        QueryParameters queryParameters = event.getLocation().getQueryParameters();
        this.filter = null;
        List parFIlter = (List)queryParameters.getParameters().get("filter");
        if (parFIlter != null) {
            this.filter = (String)parFIlter.get(0);
            this.filter = this.filter.replace("EEQQ", "=");
        }
        this.title = "";
        if (queryParameters != null && !queryParameters.getParameters().isEmpty()) {
            this.title = (String)((List)queryParameters.getParameters().get("title")).get(0);
            this.resourceName = (String)((List)queryParameters.getParameters().get("resourceName")).get(0);
            if (queryParameters.getParameters().get("apiname") != null) {
                this.apiname = (String)((List)queryParameters.getParameters().get("apiname")).get(0);
            }
            if (queryParameters.getParameters().get("cache") != null) {
                String cacheStr = (String)((List)queryParameters.getParameters().get("cache")).get(0);
                this.cache = !cacheStr.equals("false");
            }
            this.queryFormClassName = (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
            this.displayFormClassName = (String)((List)queryParameters.getParameters().get("displayFormClassName")).get(0);
            if (!this.queryFormClassName.startsWith("coop.intergal.ui.views")) {
                this.queryFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
            }
            if (!this.displayFormClassName.startsWith("coop.intergal.ui.views")) {
                this.displayFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("displayFormClassName")).get(0);
            }
            if (queryParameters.getParameters().get("gridClassName") != null) {
                this.gridClassName = (String)((List)queryParameters.getParameters().get("gridClassName")).get(0);
            }
        }
        this.createContent();
    }

    public Component createContent() {
        return this.createContent(null);
    }

    public Component createContent(DynamicDBean preSelectRow) {
        this.gridSplitDisplay.setOrientation(SplitLayout.Orientation.HORIZONTAL);
        this.displaySplitSubGrid.setOrientation(SplitLayout.Orientation.VERTICAL);
        this.grid.setDisplayFormClassName(this.displayFormClassName);
        this.grid.setDisplay(this.divDisplay);
        this.grid.setDivSubGrid(this.divSubGrid);
        this.grid.setButtonsForm(this.buttons);
        this.grid.setButtonsRowVisible(false);
        this.grid.setLayout(this);
        this.grid.setResourceName(this.resourceName);
        if (this.grid.getGrid() != null) {
            this.grid.getGrid().addSelectionListener((SelectionListener & Serializable)e -> {
                if (e.getFirstSelectedItem().isPresent()) {
                    DynamicDBean seletedRow = (DynamicDBean)e.getFirstSelectedItem().get();
                    if (this.extraFilterToSelect != null) {
                        this.keepSessionDataForFilter(seletedRow, this.extraFilterToSelect);
                    }
                    this.grid.showBean(seletedRow);
                }
            });
        }
        if (!(this.apiname == null || this.apiname.length() == 0)) {
            this.filter = this.filter != null && this.filter.length() > 0 ? this.filter + "%20%AND%20APIname='" + this.apiname + "'" : "APIname='" + this.apiname + "'";
        }
        this.grid.setFilter(this.filter);
        System.out.println("DynamicGridDisplay.beforeEnter() CACHE " + this.cache);
        this.grid.setCache(this.cache);
        if (this.gridClassName != null && this.gridClassName.equals("TreeGrid")) {
            this.grid.setupTreeGrid(null);
        } else {
            this.grid.setupGrid(false, true);
        }
        if (preSelectRow != null) {
            this.grid.showBean(preSelectRow);
        }
        this.buttons.setVisible(false);
        this.buttons.addSaveListener((ComponentEventListener<FormButtonsBar.SaveEvent>)(ComponentEventListener & Serializable)e -> this.grid.saveSelectedRow(this.apiname));
        this.buttons.addCancelListener((ComponentEventListener<FormButtonsBar.CancelEvent>)(ComponentEventListener & Serializable)e -> this.grid.undoSelectedRow());
        this.buttons.addAddListener((ComponentEventListener<FormButtonsBar.AddEvent>)(ComponentEventListener & Serializable)e -> this.grid.insertANewRow());
        this.buttons.addDeleteListener((ComponentEventListener<FormButtonsBar.DeleteEvent>)(ComponentEventListener & Serializable)e -> this.grid.DeleteARow());
        this.buttons.addPrintListener((ComponentEventListener<FormButtonsBar.PrintEvent>)(ComponentEventListener & Serializable)e -> this.grid.PrintARow());
        return this;
    }

    private void keepSessionDataForFilter(DynamicDBean seletedRow, String extraFilterToSelect2) {
        if (extraFilterToSelect2 != null && extraFilterToSelect2.indexOf("#SVKN#") > -1) {
            int idxStart = this.extraFilterToSelect.indexOf("#SVKN#") + 6;
            int idxEnd = this.extraFilterToSelect.indexOf("#SVNKEnd#");
            String sVkn = this.extraFilterToSelect.substring(idxStart, idxEnd);
            String field = this.extraFilterToSelect.substring(0, idxStart - 7);
            String valueOfField = seletedRow.getRowJSon().get(field).asText();
            UtilSessionData.setFormParams(sVkn, valueOfField);
        }
    }

    public String getDisplayFormClassName() {
        return this.displayFormClassName;
    }

    public void setDisplayFormClassName(String displayFormClassName) {
        this.displayFormClassName = displayFormClassName;
    }

    public String getPageTitle() {
        return this.title;
    }
}

